/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartBuildEventImpl
extends StartEventImpl
implements StartBuildEvent {
    private final String myBuildTitle;
    private final String myWorkingDir;
    @Nullable
    private BuildProcessHandler myProcessHandler;
    private Consumer<ConsoleView> myAttachedConsoleConsumer;
    @NotNull
    private final List<AnAction> myRestartActions = new SmartList();
    @NotNull
    private final List<Filter> myFilters = new SmartList();
    @Nullable
    private ExecutionEnvironment myExecutionEnvironment;
    @Nullable
    private Supplier<RunContentDescriptor> myContentDescriptorSupplier;

    public StartBuildEventImpl(@NotNull BuildDescriptor descriptor, @NotNull String message) {
        super(descriptor.getId(), null, descriptor.getStartTime(), message);
        this.myBuildTitle = descriptor.getTitle();
        this.myWorkingDir = descriptor.getWorkingDir();
    }

    public String getBuildTitle() {
        return this.myBuildTitle;
    }

    @NotNull
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    @Nullable
    public BuildProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        return this.myRestartActions.toArray(AnAction.EMPTY_ARRAY);
    }

    @NotNull
    public Filter[] getExecutionFilters() {
        return this.myFilters.toArray(Filter.EMPTY_ARRAY);
    }

    @Nullable
    public Supplier<RunContentDescriptor> getContentDescriptorSupplier() {
        return this.myContentDescriptorSupplier;
    }

    @Nullable
    public Consumer<ConsoleView> getAttachedConsoleConsumer() {
        return this.myAttachedConsoleConsumer;
    }

    public StartBuildEventImpl withProcessHandler(@Nullable BuildProcessHandler processHandler2, @Nullable Consumer<ConsoleView> attachedConsoleConsumer) {
        this.myProcessHandler = processHandler2;
        this.myAttachedConsoleConsumer = attachedConsoleConsumer;
        return this;
    }

    public StartBuildEventImpl withRestartAction(@NotNull AnAction anAction) {
        this.myRestartActions.add(anAction);
        return this;
    }

    public StartBuildEventImpl withRestartActions(AnAction ... actions) {
        this.myRestartActions.addAll(Arrays.asList(actions));
        return this;
    }

    public StartBuildEventImpl withExecutionEnvironment(ExecutionEnvironment env) {
        this.myExecutionEnvironment = env;
        return this;
    }

    public StartBuildEventImpl withContentDescriptorSupplier(Supplier<RunContentDescriptor> contentDescriptorSupplier) {
        this.myContentDescriptorSupplier = contentDescriptorSupplier;
        return this;
    }

    public StartBuildEventImpl withExecutionFilter(@NotNull Filter filter) {
        this.myFilters.add(filter);
        return this;
    }

    public StartBuildEventImpl withExecutionFilters(Filter ... filters) {
        this.myFilters.addAll(Arrays.asList(filters));
        return this;
    }
}

