/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildOutputInstantReaderImpl
implements BuildOutputInstantReader,
Closeable,
Appendable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.build.output.BuildOutputInstantReader");
    private static final int MAX_LINES_BUFFER_SIZE = 50;
    private final Object myBuildId;
    @Nullable
    private StringBuilder myBuffer;
    private final BlockingQueue<String> myQueue = new LinkedTransferQueue<String>();
    private int myCurrentIndex = -1;
    private final LinkedList<String> myLinesBuffer = new LinkedList();
    private static final String SHUTDOWN_PILL = new String("Poison Pill Shutdown");
    private final Thread myThread;
    private final AtomicBoolean myStarted = new AtomicBoolean();
    private final AtomicBoolean myClosed = new AtomicBoolean();

    public BuildOutputInstantReaderImpl(@NotNull Object buildId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<BuildOutputParser> parsers) {
        this.myBuildId = buildId;
        this.myThread = new Thread(() -> {
            String line;
            Ref lastMessageRef = Ref.create();
            Consumer<BuildEvent> messageConsumer = event -> {
                if (!event.equals(lastMessageRef.get())) {
                    buildProgressListener.onEvent(event);
                }
                lastMessageRef.set(event);
            };
            while ((line = this.readLine()) != null) {
                BuildOutputParser parser;
                if (line.trim().isEmpty()) continue;
                Iterator iterator = parsers.iterator();
                while (iterator.hasNext() && !(parser = (BuildOutputParser)iterator.next()).parse(line, (BuildOutputInstantReader)new BuildOutputInstantReaderWrapper(this), messageConsumer)) {
                }
            }
        }, "Build output processor");
    }

    public Object getBuildId() {
        return this.myBuildId;
    }

    @Override
    public BuildOutputInstantReaderImpl append(CharSequence csq) {
        for (int i = 0; i < csq.length(); ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public BuildOutputInstantReaderImpl append(CharSequence csq, int start2, int end) {
        this.append(csq.subSequence(start2, end));
        return this;
    }

    @Override
    public BuildOutputInstantReaderImpl append(char c) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        if (c == '\n') {
            this.doFlush();
        } else {
            this.myBuffer.append(c);
        }
        return this;
    }

    @Override
    public void close() {
        this.doFlush();
        try {
            this.myQueue.put(SHUTDOWN_PILL);
            this.myThread.join(TimeUnit.MINUTES.toMillis(1L));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.myClosed.set(true);
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        if (this.myClosed.get()) {
            LOG.warn("Build output reader closed");
            this.myBuffer.setLength(0);
            return;
        }
        String line = this.myBuffer.toString();
        this.myBuffer.setLength(0);
        try {
            if (this.myStarted.compareAndSet(false, true)) {
                this.myThread.start();
            }
            this.myQueue.put(line);
        }
        catch (InterruptedException ignore) {
            this.myClosed.set(true);
        }
    }

    @Nullable
    public String readLine() {
        if (this.myCurrentIndex < -1) {
            LOG.error("Wrong buffered output lines index");
            this.myCurrentIndex = -1;
        }
        if (this.myClosed.get()) {
            if (this.myCurrentIndex > 0 && this.myLinesBuffer.size() > this.myCurrentIndex) {
                return this.myLinesBuffer.get(this.myCurrentIndex++);
            }
            return null;
        }
        ++this.myCurrentIndex;
        if (this.myLinesBuffer.size() > this.myCurrentIndex) {
            return this.myLinesBuffer.get(this.myCurrentIndex);
        }
        try {
            String line = this.myQueue.take();
            if (line == SHUTDOWN_PILL) {
                this.myClosed.set(true);
                return null;
            }
            this.myLinesBuffer.addLast(line);
            if (this.myLinesBuffer.size() > 50) {
                this.myLinesBuffer.removeFirst();
                --this.myCurrentIndex;
            }
            return line;
        }
        catch (InterruptedException ignore) {
            this.myClosed.set(true);
            return null;
        }
    }

    public void pushBack() {
        this.pushBack(1);
    }

    public void pushBack(int numberOfLines) {
        this.myCurrentIndex -= numberOfLines;
    }

    public String getCurrentLine() {
        return this.myCurrentIndex >= 0 && this.myLinesBuffer.size() > this.myCurrentIndex ? this.myLinesBuffer.get(this.myCurrentIndex) : null;
    }

    @ApiStatus.Experimental
    static int getMaxLinesBufferSize() {
        return 50;
    }

    private static class BuildOutputInstantReaderWrapper
    implements BuildOutputInstantReader {
        private final BuildOutputInstantReaderImpl myReader;
        private int myLinesRead = 0;

        public BuildOutputInstantReaderWrapper(@NotNull BuildOutputInstantReaderImpl reader) {
            this.myReader = reader;
        }

        public Object getBuildId() {
            return this.myReader.myBuildId;
        }

        @Nullable
        public String readLine() {
            String line = this.myReader.readLine();
            if (line != null) {
                ++this.myLinesRead;
            }
            return line;
        }

        public void pushBack() {
            this.pushBack(1);
        }

        public void pushBack(int numberOfLines) {
            if (numberOfLines > this.myLinesRead) {
                numberOfLines = this.myLinesRead;
            }
            this.myReader.pushBack(numberOfLines);
        }

        public String getCurrentLine() {
            return this.myReader.getCurrentLine();
        }
    }
}

