/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.buildfiles;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedBuildFileAttribute {
    private static final Logger LOG = Logger.getInstance(ForcedBuildFileAttribute.class);
    private static final FileAttribute FRAMEWORK_FILE_ATTRIBUTE = new FileAttribute("forcedBuildFileFrameworkAttribute", 2, false);
    private static final Key<String> FRAMEWORK_FILE_MARKER = Key.create((String)"forcedBuildFileFrameworkAttribute");

    private ForcedBuildFileAttribute() {
    }

    public static boolean belongsToFramework(VirtualFile file2, @NotNull String frameworkId) {
        return frameworkId.equals(ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getFrameworkIdOfBuildFile(VirtualFile file2) {
        if (!(file2 instanceof NewVirtualFile)) return (String)file2.getUserData(FRAMEWORK_FILE_MARKER);
        try (DataInputStream is = FRAMEWORK_FILE_ATTRIBUTE.readAttribute(file2);){
            if (is == null) return "";
            if (is.available() == 0) {
                String string = null;
                return string;
            }
            String string = IOUtil.readString((DataInput)is);
            return string;
        }
        catch (IOException e) {
            LOG.error(file2.getPath(), (Throwable)e);
        }
        return "";
    }

    public static void forceFileToFramework(VirtualFile file2, String frameworkId, boolean value) {
        String existingFrameworkId = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2);
        if (!StringUtil.isEmpty((String)existingFrameworkId) && !frameworkId.equals(existingFrameworkId)) {
            return;
        }
        if (value) {
            ForcedBuildFileAttribute.forceBuildFile(file2, frameworkId);
        } else {
            ForcedBuildFileAttribute.forceBuildFile(file2, null);
        }
    }

    private static void forceBuildFile(VirtualFile file2, @Nullable String value) {
        if (file2 instanceof NewVirtualFile) {
            try (DataOutputStream os = FRAMEWORK_FILE_ATTRIBUTE.writeAttribute(file2);){
                IOUtil.writeString((String)StringUtil.notNullize((String)value), (DataOutput)os);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            file2.putUserData(FRAMEWORK_FILE_MARKER, (Object)value);
        }
    }
}

