/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.ExportToHTMLManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class ExportToHTMLAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        try {
            ExportToHTMLManager.executeExport(dataContext);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, CodeEditorBundle.message("file.not.found", ex.getMessage()), CommonBundle.getErrorTitle(), 0);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            presentation.setEnabled(true);
            return;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        presentation.setEnabled(psiFile != null && psiFile.getContainingDirectory() != null);
        presentation.setVisible(psiFile != null);
    }
}

