/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.ColorGenerator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorPalette;
import com.intellij.openapi.editor.colors.EditorColorPaletteFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowHighlighter {
    private static final JBColor[] RAINBOW_JB_COLORS_DEFAULT = new JBColor[]{new JBColor(10173290, 5414226), new JBColor(1133943, 12480624), new JBColor(12355152, 4028022), new JBColor(22800, 12491120), new JBColor(12341584, 10310268)};
    public static final TextAttributesKey[] RAINBOW_COLOR_KEYS = new TextAttributesKey[RAINBOW_JB_COLORS_DEFAULT.length];
    private static final int RAINBOW_COLORS_BETWEEN = 4;
    private static final String UNIT_TEST_COLORS = "#000001,#000002,#000003,#000004";
    private static final String INHERITED = "inherited";
    private static final Set<TextAttributesKey> CODE_INSIGHT_CONFLICT_KEYS = new HashSet<TextAttributesKey>(Arrays.asList(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES, CodeInsightColors.ERRORS_ATTRIBUTES, CodeInsightColors.WARNINGS_ATTRIBUTES, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.DUPLICATE_FROM_SERVER, CodeInsightColors.WEAK_WARNING_ATTRIBUTES, CodeInsightColors.INFORMATION_ATTRIBUTES, CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES, CodeInsightColors.DEPRECATED_ATTRIBUTES, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES, CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES, CodeInsightColors.JOIN_POINT, CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES, CodeInsightColors.HYPERLINK_ATTRIBUTES, CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES, CodeInsightColors.TODO_DEFAULT_ATTRIBUTES, CodeInsightColors.BOOKMARKS_ATTRIBUTES));
    private static final TextAttributesKey[] RAINBOW_TEMP_KEYS;
    public static final String RAINBOW_TYPE = "rainbow";
    private static final String RAINBOW_TEMP_PREF = "RAINBOW_TEMP_";
    public static final TextAttributesKey RAINBOW_ANCHOR;
    public static final TextAttributesKey RAINBOW_GRADIENT_DEMO;
    public static final Boolean DEFAULT_RAINBOW_ON;
    @NotNull
    private final TextAttributesScheme myColorsScheme;
    @NotNull
    private final Color[] myRainbowColors;
    public static final HighlightInfoType RAINBOW_ELEMENT;

    public RainbowHighlighter(@Nullable TextAttributesScheme colorsScheme) {
        this.myColorsScheme = colorsScheme != null ? colorsScheme : EditorColorsManager.getInstance().getGlobalScheme();
        this.myRainbowColors = RainbowHighlighter.generateColorSequence(this.myColorsScheme, colorsScheme != null);
    }

    @Nullable
    @Contract(value="_, null -> !null")
    public static Boolean isRainbowEnabled(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        if (colorsScheme instanceof SchemeMetaInfo) {
            do {
                String value = ((SchemeMetaInfo)colorsScheme).getMetaProperties().getProperty(RainbowHighlighter.getKey(language), INHERITED);
                if (String.valueOf(true).equals(value)) {
                    return Boolean.TRUE;
                }
                if (String.valueOf(false).equals(value)) {
                    return Boolean.FALSE;
                }
                if (language != null) continue;
                return DEFAULT_RAINBOW_ON;
            } while ((language = language.getBaseLanguage()) != null);
            return null;
        }
        return false;
    }

    public static boolean isRainbowEnabledWithInheritance(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        Boolean rainbowEnabled = RainbowHighlighter.isRainbowEnabled(colorsScheme, language);
        return rainbowEnabled != null ? rainbowEnabled : RainbowHighlighter.isRainbowEnabled(colorsScheme, null);
    }

    public static void setRainbowEnabled(@NotNull SchemeMetaInfo colorsScheme, @Nullable Language language, @Nullable Boolean enabled) {
        Properties properties = colorsScheme.getMetaProperties();
        String key = RainbowHighlighter.getKey(language);
        if (enabled == null || language == null && enabled == DEFAULT_RAINBOW_ON) {
            properties.remove(key);
        } else {
            properties.setProperty(key, String.valueOf(enabled));
        }
    }

    @NotNull
    private static String getKey(@Nullable Language language) {
        return "rainbow " + (language == null ? UIBundle.message((String)"color.settings.common.default.language", (Object[])new Object[0]) : language.getID());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isRainbowKey(@Nullable Object key) {
        return key instanceof String && ((String)key).startsWith(RAINBOW_TYPE);
    }

    public static void transferRainbowState(@NotNull SchemeMetaInfo dst, @NotNull SchemeMetaInfo src) {
        Properties dstProps = dst.getMetaProperties();
        dstProps.entrySet().removeIf(entry -> RainbowHighlighter.isRainbowKey(entry.getKey()));
        src.getMetaProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (RainbowHighlighter.isRainbowKey(key) && value instanceof String) {
                dstProps.setProperty((String)key, (String)value);
            }
        }));
    }

    @NotNull
    public static String generatePaletteExample(@NotNull String indent) {
        int stopCount = RAINBOW_COLOR_KEYS.length;
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(UIBundle.message((String)"color.settings.rainbow.demo.header.1", (Object[])new Object[0])).append(indent).append(UIBundle.message((String)"color.settings.rainbow.demo.header.2", (Object[])new Object[0])).append(indent);
        String tagRainbow = RAINBOW_GRADIENT_DEMO.getExternalName();
        boolean needLineBreak = true;
        for (int i = 0; i < RAINBOW_TEMP_KEYS.length; ++i) {
            sb.append(" ");
            sb.append("<").append(tagRainbow).append(">");
            String anchor2 = String.valueOf(i / stopCount + 1);
            String minor = String.valueOf(i % stopCount);
            sb.append(i % stopCount == 0 ? "Color#" + anchor2 : "SC" + anchor2 + "." + minor);
            sb.append("</").append(tagRainbow).append(">");
            if (!needLineBreak || i != RAINBOW_TEMP_KEYS.length / 2) continue;
            sb.append(indent);
            needLineBreak = false;
            --i;
        }
        return sb.toString();
    }

    @NotNull
    @Contract(pure=true)
    private Color calculateForeground(int colorIndex) {
        return this.myRainbowColors[colorIndex];
    }

    public int getColorsCount() {
        return this.myRainbowColors.length;
    }

    @NotNull
    private static Color[] generateColorSequence(@NotNull TextAttributesScheme colorsScheme, boolean withCorrectionAndCaching) {
        Color[] colors;
        String colorDump = ApplicationManager.getApplication().isUnitTestMode() ? UNIT_TEST_COLORS : Registry.get((String)"rainbow.highlighter.colors").asString();
        List registryColors = StringUtil.split((String)colorDump, (String)",");
        if (!registryColors.isEmpty()) {
            return (Color[])registryColors.stream().map(s -> ColorUtil.fromHex((String)s.trim())).toArray(Color[]::new);
        }
        if (withCorrectionAndCaching && (colors = RainbowHighlighter.getColorsFromCache(colorsScheme)) != null) {
            return colors;
        }
        return RainbowHighlighter.generateColors(colorsScheme, withCorrectionAndCaching);
    }

    @NotNull
    public static Color[] testRainbowGenerateColors(@NotNull TextAttributesScheme colorsScheme) {
        return RainbowHighlighter.generateColors(colorsScheme, true);
    }

    @NotNull
    private static Color[] generateColors(@NotNull TextAttributesScheme colorsScheme, boolean withCorrectionAndCaching) {
        List stopRainbowColors = ContainerUtil.map((Object[])RAINBOW_COLOR_KEYS, key -> RainbowHighlighter.getRainbowColorFromAttribute(colorsScheme.getAttributes(key)));
        List rainbowColors = ColorGenerator.generateLinearColorSequence(stopRainbowColors, 4);
        if (withCorrectionAndCaching && colorsScheme instanceof EditorColorsScheme) {
            EditorColorPalette palette = EditorColorPaletteFactory.getInstance().getPalette((EditorColorsScheme)colorsScheme, Language.ANY).collectColorsWithFilter(attr -> RainbowHighlighter.getRainbowColorFromAttribute(attr), true);
            ArrayList<Pair> colorCircles = new ArrayList<Pair>();
            Color background = ((EditorColorsScheme)colorsScheme).getDefaultBackground();
            boolean schemeIsDark = ColorUtil.isDark((Color)background);
            double minDistanceWithOrdinal = schemeIsDark ? 0.06 : 0.1;
            double minDistanceWithDiagnostic = schemeIsDark ? 0.12 : 0.2;
            colorCircles.add(Pair.create((Object)background, (Object)0.24));
            palette.getEntries().forEach(entry -> colorCircles.add(Pair.create(entry.getKey(), (Object)(Collections.disjoint(CODE_INSIGHT_CONFLICT_KEYS, (Collection)entry.getValue()) ? minDistanceWithOrdinal : minDistanceWithDiagnostic))));
            rainbowColors = ContainerUtil.map(rainbowColors, rainbowColor -> RainbowHighlighter.resolveConflict(colorCircles, rainbowColor, 0));
            for (int i = 0; i < RAINBOW_TEMP_KEYS.length; ++i) {
                TextAttributesKey key2 = RAINBOW_TEMP_KEYS[i];
                TextAttributes attributes = RainbowHighlighter.createRainbowAttribute((Color)rainbowColors.get(i));
                ((EditorColorsScheme)colorsScheme).setAttributes(key2, attributes);
            }
        }
        return rainbowColors.toArray(new Color[0]);
    }

    private static Color resolveConflict(@NotNull List<Pair<Color, Double>> colorCircles, @NotNull Color sampleColor, int nestLevel) {
        if (nestLevel > 4) {
            return sampleColor;
        }
        for (Pair<Color, Double> circle : colorCircles) {
            Color paletteColor = (Color)circle.first;
            double distance2 = RainbowHighlighter.colorDistance01(sampleColor, paletteColor);
            if (!(distance2 < (Double)circle.second)) continue;
            float[] rgb = RainbowHighlighter.rgbDiffColor(sampleColor, paletteColor);
            double factor = 256.0 * (Double)circle.second / RainbowHighlighter.getLength(rgb);
            int mod = nestLevel % 4;
            int r = RainbowHighlighter.normalize((double)sampleColor.getRed() + (double)rgb[0] * factor * (double)(mod == 3 ? 2 : 1));
            int g = RainbowHighlighter.normalize((double)sampleColor.getGreen() + (double)rgb[1] * factor * (double)(mod == 1 ? 2 : 1));
            int b = RainbowHighlighter.normalize((double)sampleColor.getBlue() + (double)rgb[2] * factor * (double)(mod == 2 ? 2 : 1));
            float[] hsbNew = Color.RGBtoHSB(r, g, b, null);
            float[] hsbOrig = Color.RGBtoHSB(sampleColor.getRed(), sampleColor.getGreen(), sampleColor.getBlue(), null);
            return RainbowHighlighter.resolveConflict(colorCircles, Color.getHSBColor(hsbNew[0], hsbNew[1], (hsbOrig[2] + hsbNew[2]) / 2.0f), ++nestLevel);
        }
        return sampleColor;
    }

    private static int normalize(double b) {
        return Math.min(Math.max(1, (int)b), 254);
    }

    public static double colorDistance01(@NotNull Color c1, @NotNull Color c2) {
        return RainbowHighlighter.getLength(RainbowHighlighter.YPbPr01(RainbowHighlighter.rgbDiffColor(c1, c2)));
    }

    private static double getLength(@NotNull float[] components) {
        return Math.sqrt(components[0] * components[0] + components[1] * components[1] + components[2] * components[2]);
    }

    @NotNull
    private static float[] rgbDiffColor(@NotNull Color c1, @NotNull Color c2) {
        return new float[]{c1.getRed() - c2.getRed(), c1.getGreen() - c2.getGreen(), c1.getBlue() - c2.getBlue()};
    }

    @NotNull
    @Contract(pure=true)
    private static float[] YPbPr01(@NotNull float[] rgb) {
        return new float[]{(float)((0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2]) / 256.0), (float)((-0.169 * (double)rgb[0] - 0.331 * (double)rgb[1] + 0.5 * (double)rgb[2]) / 256.0), (float)((0.5 * (double)rgb[0] - 0.419 * (double)rgb[1] - 0.081 * (double)rgb[2]) / 256.0)};
    }

    @Nullable
    private static Color[] getColorsFromCache(@NotNull TextAttributesScheme colorsScheme) {
        ArrayList<Color> colors = new ArrayList<Color>();
        boolean validCache = true;
        for (TextAttributesKey tempKey : RAINBOW_TEMP_KEYS) {
            TextAttributes attributes = colorsScheme.getAttributes(tempKey);
            if (attributes == null) {
                validCache = false;
                break;
            }
            colors.add(RainbowHighlighter.getRainbowColorFromAttribute(attributes));
        }
        if (!validCache) {
            return null;
        }
        return colors.toArray(new Color[0]);
    }

    @Nullable
    private static Color getRainbowColorFromAttribute(@NotNull TextAttributes attributes) {
        return attributes.getForegroundColor();
    }

    private static void setRainbowColorToAttribute(@NotNull TextAttributes attributes, @Nullable Color rainbowColor) {
        attributes.setForegroundColor(rainbowColor);
    }

    @NotNull
    public TextAttributesKey[] getRainbowTempKeys() {
        return RAINBOW_TEMP_KEYS;
    }

    public static boolean isRainbowTempKey(TextAttributesKey key) {
        return key.getExternalName().startsWith(RAINBOW_TEMP_PREF);
    }

    public HighlightInfo getInfo(int colorIndex, @Nullable PsiElement id, @Nullable TextAttributesKey colorKey) {
        return id == null ? null : this.getInfoBuilder(colorIndex, colorKey).range(id).create();
    }

    public HighlightInfo getInfo(int colorIndex, int start2, int end, @Nullable TextAttributesKey colorKey) {
        return this.getInfoBuilder(colorIndex, colorKey).range(start2, end).create();
    }

    @NotNull
    private HighlightInfo.Builder getInfoBuilder(int colorIndex, @Nullable TextAttributesKey colorKey) {
        if (colorKey == null) {
            colorKey = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
        }
        return HighlightInfo.newHighlightInfo(RAINBOW_ELEMENT).textAttributes(TextAttributes.fromFlyweight((AttributesFlyweight)this.myColorsScheme.getAttributes(colorKey).getFlyweight().withForeground(this.calculateForeground(colorIndex))));
    }

    @NotNull
    public static TextAttributes createRainbowAttribute(@Nullable Color color) {
        TextAttributes ret = new TextAttributes();
        RainbowHighlighter.setRainbowColorToAttribute(ret, color);
        return ret;
    }

    public static Map<String, TextAttributesKey> createRainbowHLM() {
        HashMap<String, TextAttributesKey> hashMap = new HashMap<String, TextAttributesKey>();
        hashMap.put(RAINBOW_ANCHOR.getExternalName(), RAINBOW_ANCHOR);
        hashMap.put(RAINBOW_GRADIENT_DEMO.getExternalName(), RAINBOW_GRADIENT_DEMO);
        for (TextAttributesKey key : RAINBOW_TEMP_KEYS) {
            hashMap.put(key.getExternalName(), key);
        }
        return hashMap;
    }

    static {
        for (int i = 0; i < RAINBOW_JB_COLORS_DEFAULT.length; ++i) {
            RainbowHighlighter.RAINBOW_COLOR_KEYS[i] = TextAttributesKey.createTextAttributesKey((String)("RAINBOW_COLOR" + i), (TextAttributes)RainbowHighlighter.createRainbowAttribute((Color)RAINBOW_JB_COLORS_DEFAULT[i]));
        }
        List<Color> stopRainbowColors = Collections.nCopies(RAINBOW_COLOR_KEYS.length, Color.red);
        List<Color> rainbowColors = ColorGenerator.generateLinearColorSequence(stopRainbowColors, 4);
        TextAttributesKey[] keys = new TextAttributesKey[rainbowColors.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = TextAttributesKey.createTempTextAttributesKey((String)(RAINBOW_TEMP_PREF + i), null);
        }
        RAINBOW_TEMP_KEYS = keys;
        RAINBOW_ANCHOR = TextAttributesKey.createTextAttributesKey((String)RAINBOW_TYPE);
        RAINBOW_GRADIENT_DEMO = TextAttributesKey.createTextAttributesKey((String)"rainbow_demo");
        DEFAULT_RAINBOW_ON = Boolean.FALSE;
        RAINBOW_ELEMENT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.CONSTANT);
    }
}

