/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    public static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language) {
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, language, null);
    }

    private static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language, @Nullable PsiElement initialElement) {
        PsiElement element;
        PsiElement element1 = file2.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.getViewProvider().findElementAt(startOffset, language);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        PsiElement psiElement = element = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType((PsiElement)commonParent, klass);
        if (element == initialElement) {
            return (T)element;
        }
        if (element == null || element.getTextRange().getStartOffset() != startOffset || element.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element;
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element) {
        return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, false);
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element, boolean useFileLanguage) {
        PsiFile psiFile = element.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        Language language = useFileLanguage ? psiFile.getLanguage() : PsiUtilCore.getDialect(element);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        Object elementInRange = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element.getClass(), language, element);
        rangeMarker.dispose();
        return (T)elementInRange;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets, true, true, '\"', '\'');
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, boolean slashMustBeEscaped, boolean exitOnEscapingWrongSymbol, char ... endChars) {
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    if (CharArrayUtil.indexOf((char[])endChars, (char)c, (int)0, (int)endChars.length) != -1) {
                        outChars.append(c);
                        break;
                    }
                    if (!exitOnEscapingWrongSymbol) {
                        if (!slashMustBeEscaped) {
                            outChars.append('\\');
                            if (sourceOffsets != null) {
                                sourceOffsets[outChars.length() - outOffset] = index - 1;
                            }
                        }
                        outChars.append(c);
                        break;
                    }
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    @Nullable
    public static TextRange mapBackStringRange(@NotNull String text, int from, int to) {
        if (from > to || to < 0) {
            return null;
        }
        if (text.startsWith("`")) {
            return new TextRange(from + 1, to + 1);
        }
        if (!text.startsWith("\"")) {
            return null;
        }
        if (text.indexOf(92) == -1) {
            return new TextRange(from + 1, to + 1);
        }
        int curOffset = 0;
        int mappedFrom = -1;
        int mappedTo = -1;
        int end = text.length() - 1;
        int i = 1;
        while (i <= end) {
            char c;
            if (curOffset == from) {
                mappedFrom = i;
            }
            if (curOffset == to) {
                mappedTo = i;
                break;
            }
            if (i == end) break;
            if ((c = text.charAt(i++)) == '\\') {
                char c1;
                if (i == end) {
                    return null;
                }
                if ((c1 = text.charAt(i++)) == 'u') {
                    while (i < end && text.charAt(i) == 'u') {
                        ++i;
                    }
                    i += 4;
                } else if (c1 >= '0' && c1 <= '7') {
                    char c2;
                    char c3 = c2 = i < end ? text.charAt(i) : (char)'\u0000';
                    if (c2 >= '0' && c2 <= '7') {
                        char c32;
                        char c4 = c32 = ++i < end ? text.charAt(i) : (char)'\u0000';
                        if (c32 >= '0' && c32 <= '7' && c1 <= '3') {
                            ++i;
                        }
                    }
                }
            }
            ++curOffset;
        }
        if (mappedFrom >= 0 && mappedTo >= 0) {
            return new TextRange(mappedFrom, mappedTo);
        }
        return null;
    }
}

