/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatChangedTextUtil {
    public static final Key<CharSequence> TEST_REVISION_CONTENT = Key.create((String)"test.revision.content");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    protected FormatChangedTextUtil() {
    }

    @NotNull
    public static FormatChangedTextUtil getInstance() {
        return (FormatChangedTextUtil)ServiceManager.getService(FormatChangedTextUtil.class);
    }

    public static boolean hasChanges(@NotNull PsiFile file2) {
        Project project = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file2, @NotNull Project project) {
        Collection changes2 = ChangeListManager.getInstance((Project)project).getChangesIn(file2);
        for (Change change : changes2) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files2, @NotNull Project project) {
        for (VirtualFile file2 : files2) {
            if (!FormatChangedTextUtil.hasChanges(file2, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(@NotNull Project project) {
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)ReadAction.compute(() -> ModuleManager.getInstance((Project)project).getModifiableModel());
        try {
            for (Module module : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<? extends PsiDirectory> dirs) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes2 = ContainerUtil.newArrayList();
        for (PsiDirectory psiDirectory : dirs) {
            changes2.addAll(changeListManager.getChangesIn(psiDirectory.getVirtualFile()));
        }
        return FormatChangedTextUtil.getChangedFiles(project, changes2);
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(final @NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private final PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        return ContainerUtil.mapNotNull(changes2, (Function)changeToPsiFileMapper);
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) {
        return ContainerUtil.emptyList();
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return -1;
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        return false;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) {
        return null;
    }

    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, @NotNull Change[] changes2, @NotNull java.util.function.Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        return Arrays.stream(changes2).map(Change::getVirtualFile).filter(Objects::nonNull).flatMap(file2 -> ((List)elementsConvertor.apply((VirtualFile)file2)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        o.run();
    }
}

