/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutCodeDialog
extends DialogWrapper {
    private final Project myProject;
    private final PsiFile myFile;
    private final boolean myTextSelected;
    private final String myHelpId;
    private final LastRunReformatCodeOptionsProvider myLastRunOptions;
    private final LayoutCodeOptions myRunOptions;
    private JPanel myButtonsPanel;
    private JCheckBox myOptimizeImportsCb;
    private JCheckBox myRearrangeCodeCb;
    private JCheckBox myApplyCodeCleanup;
    private JRadioButton myOnlyVCSChangedTextRb;
    private JRadioButton mySelectedTextRadioButton;
    private JRadioButton myWholeFileRadioButton;
    private JPanel myActionsPanel;
    private JPanel myScopePanel;
    private JLabel myOptionalLabel;

    public LayoutCodeDialog(@NotNull Project project, @NotNull PsiFile file2, boolean textSelected, String helpId) {
        super(project, true);
        this.myFile = file2;
        this.myProject = project;
        this.myTextSelected = textSelected;
        this.myHelpId = helpId;
        this.$$$setupUI$$$();
        this.myLastRunOptions = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        this.myRunOptions = this.createOptionsBundledOnDialog();
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle("Reformat File: " + file2.getName());
        this.init();
    }

    protected void init() {
        super.init();
        this.setUpActions();
        this.setUpTextRangeMode();
    }

    private void setUpTextRangeMode() {
        this.mySelectedTextRadioButton.setEnabled(this.myTextSelected);
        if (!this.myTextSelected) {
            this.mySelectedTextRadioButton.setToolTipText("No text selected in editor");
        }
        boolean fileHasChanges = FormatChangedTextUtil.hasChanges(this.myFile);
        if (this.myFile.getVirtualFile() instanceof LightVirtualFile) {
            this.myOnlyVCSChangedTextRb.setVisible(false);
        } else {
            String hint;
            this.myOnlyVCSChangedTextRb.setEnabled(fileHasChanges);
            if (!fileHasChanges && (hint = this.getChangesNotAvailableHint()) != null) {
                this.myOnlyVCSChangedTextRb.setToolTipText(hint);
            }
        }
        this.myWholeFileRadioButton.setEnabled(true);
        if (this.myTextSelected) {
            this.mySelectedTextRadioButton.setSelected(true);
        } else {
            boolean lastRunProcessedChangedText;
            boolean bl = lastRunProcessedChangedText = this.myLastRunOptions.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
            if (lastRunProcessedChangedText && fileHasChanges) {
                this.myOnlyVCSChangedTextRb.setSelected(true);
            } else {
                this.myWholeFileRadioButton.setSelected(true);
            }
        }
    }

    private void setUpActions() {
        boolean canOptimizeImports = !LanguageImportStatements.INSTANCE.forFile(this.myFile).isEmpty();
        this.myOptimizeImportsCb.setVisible(canOptimizeImports);
        if (canOptimizeImports) {
            this.myOptimizeImportsCb.setSelected(this.myLastRunOptions.getLastOptimizeImports());
        }
        boolean canRearrangeCode = Rearranger.EXTENSION.forLanguage(this.myFile.getLanguage()) != null;
        this.myRearrangeCodeCb.setVisible(canRearrangeCode);
        if (canRearrangeCode) {
            this.myRearrangeCodeCb.setSelected(this.myLastRunOptions.isRearrangeCode(this.myFile.getLanguage()));
        }
        this.myApplyCodeCleanup.setSelected(this.myLastRunOptions.getLastCodeCleanup());
        this.myOptionalLabel.setVisible(canOptimizeImports || canRearrangeCode);
    }

    @Nullable
    private String getChangesNotAvailableHint() {
        if (!VcsUtil.isFileUnderVcs((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)this.myFile.getVirtualFile()))) {
            return "File not under VCS root";
        }
        if (!FormatChangedTextUtil.hasChanges(this.myFile)) {
            return "File was not changed since last revision";
        }
        return null;
    }

    private void saveCurrentConfiguration() {
        if (this.myOptimizeImportsCb.isEnabled()) {
            this.myLastRunOptions.saveOptimizeImportsState(this.myRunOptions.isOptimizeImports());
        }
        if (this.myRearrangeCodeCb.isEnabled()) {
            this.myLastRunOptions.saveRearrangeState(this.myFile.getLanguage(), this.myRunOptions.isRearrangeCode());
        }
        if (this.myApplyCodeCleanup.isEnabled()) {
            this.myLastRunOptions.saveCodeCleanupState(this.myApplyCodeCleanup.isSelected());
        }
        if (!this.mySelectedTextRadioButton.isSelected() && this.myOnlyVCSChangedTextRb.isEnabled()) {
            this.myLastRunOptions.saveProcessVcsChangedTextState(this.myOnlyVCSChangedTextRb.isSelected());
        }
    }

    private LayoutCodeOptions createOptionsBundledOnDialog() {
        return new LayoutCodeOptions(){

            @Override
            public TextRangeType getTextRangeType() {
                if (LayoutCodeDialog.this.myOnlyVCSChangedTextRb.isSelected()) {
                    return TextRangeType.VCS_CHANGED_TEXT;
                }
                if (LayoutCodeDialog.this.mySelectedTextRadioButton.isSelected()) {
                    return TextRangeType.SELECTED_TEXT;
                }
                return TextRangeType.WHOLE_FILE;
            }

            @Override
            public boolean isRearrangeCode() {
                return LayoutCodeDialog.this.myRearrangeCodeCb.isEnabled() && LayoutCodeDialog.this.myRearrangeCodeCb.isSelected();
            }

            @Override
            public boolean isOptimizeImports() {
                return LayoutCodeDialog.this.myOptimizeImportsCb.isEnabled() && LayoutCodeDialog.this.myOptimizeImportsCb.isSelected();
            }

            @Override
            public boolean isCodeCleanup() {
                return LayoutCodeDialog.this.myApplyCodeCleanup.isEnabled() && LayoutCodeDialog.this.myApplyCodeCleanup.isSelected();
            }
        };
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myButtonsPanel;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doOKAction() {
        this.saveCurrentConfiguration();
        super.doOKAction();
    }

    public LayoutCodeOptions getRunOptions() {
        return this.myRunOptions;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 3, 1, 1, 0, 2, 1, 6, null, null, null));
        Splitter splitter = new Splitter();
        jPanel3.add((Component)splitter, new GridConstraints(1, 4, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myActionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptimizeImportsCb = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox3.setText("Optimize imports");
        jCheckBox3.setMnemonic('O');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRearrangeCodeCb = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setText("Rearrange code");
        jCheckBox2.setMnemonic('N');
        jCheckBox2.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myApplyCodeCleanup = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setText("Code cleanup");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScopePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOnlyVCSChangedTextRb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton3.setText("Only VCS changed text");
        jRadioButton3.setMnemonic('V');
        jRadioButton3.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySelectedTextRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton2.setText("Selected text");
        jRadioButton2.setMnemonic('S');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWholeFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.setText("Whole file");
        jRadioButton.setMnemonic('W');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Scope:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionalLabel = jLabel = new JLabel();
        jLabel.setText("Optional:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
        buttonGroup2.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myButtonsPanel;
    }
}

