/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @Override
    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) {
        ChangedRangesInfo helper = this.getChangedRangesInfo(file2);
        return helper != null ? helper.allChangedRanges : ContainerUtil.newArrayList();
    }

    @Override
    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) {
        CharSequence testContent;
        Project project = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file2.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file2.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file2.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, contentFromVcs) : null;
    }

    @Override
    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, @NotNull Change[] changes2, @NotNull Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        List result2 = ContainerUtil.newSmartList();
        for (Change change : changes2) {
            List elements;
            Document document;
            VirtualFile file2;
            if (change.getType() == Change.Type.DELETED || !(change.getAfterRevision() instanceof CurrentContentRevision) || (file2 = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile()) == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            List<T> apply2 = elementsConvertor.apply((VirtualFile)file2);
            List list2 = elements = apply2 == null ? null : ContainerUtil.skipNulls(apply2);
            if (ContainerUtil.isEmpty((Collection)elements)) continue;
            BitSet changedLines = VcsAwareFormatChangedTextUtil.getChangedLines(project, document, change);
            if (changedLines != null) {
                for (PsiElement element : elements) {
                    if (!VcsAwareFormatChangedTextUtil.isElementChanged(element, document, changedLines)) continue;
                    result2.add(element);
                }
                continue;
            }
            result2.addAll(elements);
        }
        return result2;
    }

    @Nullable
    private static BitSet getChangedLines(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        if (change.getType() == Change.Type.NEW) {
            return null;
        }
        List<? extends Range> ranges = VcsAwareFormatChangedTextUtil.getChangedRanges(project, document, change);
        if (ranges == null) {
            return null;
        }
        BitSet changedLines = new BitSet();
        for (Range range2 : ranges) {
            if (range2.getType() == 3) {
                changedLines.set(Math.max(0, range2.getLine1() - 1), range2.getLine1() + 1);
                continue;
            }
            changedLines.set(range2.getLine1(), range2.getLine2());
        }
        return changedLines;
    }

    @Nullable
    private static List<? extends Range> getChangedRanges(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null) {
            if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
                if (ranges != null) {
                    return ContainerUtil.filter(ranges, range2 -> range2.getChangelistId().equals(changeListId));
                }
                return null;
            }
            return tracker.getRanges();
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        if (contentFromVcs != null) {
            return VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        }
        return null;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision = change.getBeforeRevision();
        if (revision == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List ranges;
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null && (ranges = tracker.getRanges()) != null) {
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    private static ChangedRangesInfo calculateChangedRangesInfo(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return RangesBuilder.createRanges(document.getImmutableCharSequence(), StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n"));
    }

    @Override
    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range2 : changedRanges) {
            int inserted = range2.getLine2() - range2.getLine1();
            int deleted = range2.getVcsLine2() - range2.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        ArrayList ranges = ContainerUtil.newArrayList();
        ArrayList insertedRanges = ContainerUtil.newArrayList();
        for (Range range2 : changedRanges) {
            if (range2.getType() == 3) continue;
            int changeStartLine = range2.getLine1();
            int changeEndLine = range2.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range2.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo((List)ranges, (List)insertedRanges);
    }

    @Override
    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        boolean isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file2.getVirtualFile()));
        if (!isUnderVcs) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file2.getVirtualFile());
    }

    @Override
    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }
}

