/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

class ActionTracker {
    private boolean myActionsHappened;
    private final Editor myEditor;
    private final Project myProject;
    private boolean myIgnoreDocumentChanges;

    ActionTracker(Editor editor, Disposable parentDisposable) {
        this.myEditor = editor;
        this.myProject = editor.getProject();
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                ActionTracker.this.myActionsHappened = true;
            }

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                ActionTracker.this.myActionsHappened = true;
            }
        });
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (!ActionTracker.this.myIgnoreDocumentChanges) {
                    ActionTracker.this.myActionsHappened = true;
                }
            }
        }, parentDisposable);
        this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                ActionTracker.this.myActionsHappened = true;
            }

            public void caretRemoved(@NotNull CaretEvent event) {
                ActionTracker.this.myActionsHappened = true;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (!ActionTracker.this.myIgnoreDocumentChanges) {
                    ActionTracker.this.myActionsHappened = true;
                }
            }
        }, parentDisposable);
    }

    void ignoreCurrentDocumentChange() {
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        this.myIgnoreDocumentChanges = true;
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myProject, (Disposable)disposable);
        this.myProject.getMessageBus().connect(disposable).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandFinished(@NotNull CommandEvent event) {
                Disposer.dispose((Disposable)disposable);
                ActionTracker.this.myIgnoreDocumentChanges = false;
            }
        });
    }

    boolean hasAnythingHappened() {
        return this.myActionsHappened || DumbService.getInstance((Project)this.myProject).isDumb() || this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid();
    }
}

