/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionServiceUtil");
    private static final Key<SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    public static CompletionInitializationContextImpl createCompletionInitializationContext(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, int invocationCount, CompletionType completionType) {
        return (CompletionInitializationContextImpl)((Object)WriteAction.compute(() -> {
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            CompletionAssertions.checkEditorValid(editor);
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project);
            assert (psiFile != null) : "no PSI file: " + FileDocumentManager.getInstance().getFile(editor.getDocument());
            psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
            CompletionAssertions.assertCommitSuccessful(editor, psiFile);
            return CompletionInitializationUtil.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret, completionType);
        }));
    }

    private static CompletionInitializationContextImpl runContributorsBeforeCompletion(Editor editor, PsiFile psiFile, int invocationCount, @NotNull Caret caret, CompletionType completionType) {
        final Ref current = Ref.create(null);
        CompletionInitializationContextImpl context = new CompletionInitializationContextImpl(editor, caret, psiFile, completionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + this.dummyIdentifierChanger);
                }
                this.dummyIdentifierChanger = (CompletionContributor)current.get();
            }
        };
        Project project = psiFile.getProject();
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)context.getPositionLanguage(), (Project)project)) {
            current.set((Object)contributor);
            contributor.beforeCompletion((CompletionInitializationContext)context);
            CompletionAssertions.checkEditorValid(editor);
            assert (!PsiDocumentManager.getInstance((Project)project).isUncommited(editor.getDocument())) : "Contributor " + contributor + " left the document uncommitted";
        }
        return context;
    }

    public static CompletionParameters prepareCompletionParameters(CompletionInitializationContext initContext, CompletionProcessEx indicator) {
        OffsetsInFile hostCopyOffsets = CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator, indicator.getHostOffsets());
        if (hostCopyOffsets == null) {
            return null;
        }
        indicator.registerChildDisposable(hostCopyOffsets::getOffsets);
        OffsetsInFile finalOffsets = CompletionInitializationUtil.toInjectedIfAny(initContext.getFile(), hostCopyOffsets);
        indicator.registerChildDisposable(finalOffsets::getOffsets);
        CompletionParameters parameters = CompletionInitializationUtil.createCompletionParameters(initContext, indicator, finalOffsets);
        indicator.setParameters(parameters);
        return parameters;
    }

    @NotNull
    private static CompletionParameters createCompletionParameters(CompletionInitializationContext initContext, CompletionProcessEx indicator, OffsetsInFile finalOffsets) {
        int offset = finalOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = finalOffsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CompletionInitializationUtil.findCompletionPositionLeaf(finalOffsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)new CompletionContext(fileCopy, finalOffsets.getOffsets()));
        return new CompletionParameters(insertedElement, originalFile, initContext.getCompletionType(), offset, initContext.getInvocationCount(), initContext.getEditor(), (CompletionProcess)indicator);
    }

    private static OffsetsInFile insertDummyIdentifier(CompletionInitializationContext initContext, CompletionProcessEx indicator, OffsetsInFile topLevelOffsets) {
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(initContext.getEditor());
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CompletionInitializationUtil.obtainFileCopy(topLevelOffsets.getFile());
        Document copyDocument = Objects.requireNonNull(hostCopy.getViewProvider().getDocument());
        String dummyIdentifier = initContext.getDummyIdentifier();
        int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        indicator.registerChildDisposable(() -> new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument, startOffset, endOffset, dummyIdentifier));
        OffsetsInFile copyOffsets = topLevelOffsets.replaceInCopy(hostCopy, startOffset, endOffset, dummyIdentifier);
        return hostCopy.isValid() ? copyOffsets : null;
    }

    private static OffsetsInFile toInjectedIfAny(PsiFile originalFile, OffsetsInFile hostCopyOffsets) {
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (injected instanceof PsiFileImpl && InjectedLanguageManager.getInstance((Project)originalFile.getProject()).isInjectedFragment(originalFile)) {
                ((PsiFileImpl)injected).setOriginalFile(originalFile);
            }
            DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                return translatedOffsets;
            }
        }
        return hostCopyOffsets;
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(OffsetsInFile offsets, int offset, PsiFile originalFile) {
        PsiElement insertedElement = offsets.getFile().findElementAt(offset);
        if (insertedElement == null && offsets.getFile().getTextLength() == 0) {
            insertedElement = PsiTreeUtil.getDeepestLast((PsiElement)offsets.getFile());
        }
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets, offset, originalFile, insertedElement);
        return insertedElement;
    }

    private static PsiFile obtainFileCopy(PsiFile file2) {
        Pair cached;
        boolean mayCacheCopy;
        VirtualFile virtualFile = file2.getVirtualFile();
        boolean bl = mayCacheCopy = file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_COPY_KEY)))) != null && CompletionInitializationUtil.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file2)) {
            PsiFile copy = (PsiFile)cached.first;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file2, copy);
            return copy;
        }
        PsiFile copy = (PsiFile)file2.copy();
        if (copy.isPhysical() || copy.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + file2.getLanguage() + "; file=" + file2 + " of " + file2.getClass());
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file2, copy);
        if (mayCacheCopy) {
            Document document = copy.getViewProvider().getDocument();
            assert (document != null);
            CompletionInitializationUtil.syncAcceptSlashR(file2.getViewProvider().getDocument(), document);
            file2.putUserData(FILE_COPY_KEY, (Object)new SoftReference((Object)Pair.create((Object)copy, (Object)document)));
        }
        return copy;
    }

    private static boolean isCopyUpToDate(Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current = PsiDocumentManager.getInstance((Project)copyFile.getProject()).getPsiFile(document);
        return current != null && current.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static void syncAcceptSlashR(Document originalDocument, Document documentCopy) {
        if (!(originalDocument instanceof DocumentImpl) || !(documentCopy instanceof DocumentImpl)) {
            return;
        }
        ((DocumentImpl)documentCopy).setAcceptSlashR(((DocumentImpl)originalDocument).acceptsSlashR());
    }
}

