/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.ElementPattern;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionProcessBase
implements CompletionProcessEx,
Disposable {
    protected final int myInvocationCount;
    protected final Object myLock = new String("CompletionProgressIndicator");
    protected OffsetsInFile myHostOffsets;
    private CompletionParameters myParameters;
    @NotNull
    private final Caret myCaret;
    @NotNull
    private final OffsetMap myOffsetMap;

    public CompletionProcessBase(CompletionInitializationContext context) {
        this.myInvocationCount = context.getInvocationCount();
        this.myHostOffsets = ((CompletionInitializationContextImpl)context).getHostOffsets();
        this.myCaret = context.getCaret();
        this.myOffsetMap = context.getOffsetMap();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myParameters.getOriginalFile().getProject();
    }

    @Override
    @NotNull
    public Editor getEditor() {
        return this.myParameters.getEditor();
    }

    @Override
    @NotNull
    public Caret getCaret() {
        return this.myCaret;
    }

    @Override
    @NotNull
    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    @Override
    @Nullable
    public Lookup getLookup() {
        return null;
    }

    public boolean isAutopopupCompletion() {
        return this.myInvocationCount == 0;
    }

    @Override
    @NotNull
    public OffsetsInFile getHostOffsets() {
        return this.myHostOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChildDisposable(@NotNull Supplier<Disposable> child2) {
        Object object = this.myLock;
        synchronized (object) {
            Disposer.register((Disposable)this, (Disposable)child2.get());
        }
    }

    public void dispose() {
    }

    @Override
    public void itemSelected(LookupElement item, char aChar) {
    }

    @Override
    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
    }

    @Override
    public void addAdvertisement(String message, @Nullable Color bgColor) {
    }

    @Override
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    @Override
    public void setParameters(CompletionParameters parameters) {
        this.myParameters = parameters;
    }

    @Override
    public void scheduleRestart() {
    }

    @Override
    public void prefixUpdated() {
    }
}

