/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionDataEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.util.UnmodifiableIterator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionUtil {
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailType.NONE);
            this.registerVariant(variant);
        }
    };
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz ".trim();

    @Nullable
    public static CompletionData getCompletionDataByElement(@Nullable PsiElement position, @NotNull PsiFile originalFile) {
        CompletionData mainData;
        if (position == null) {
            return null;
        }
        PsiElement parent = position.getParent();
        Language language = parent == null ? position.getLanguage() : parent.getLanguage();
        LanguageFileType fileType = language.getAssociatedFileType();
        if (fileType != null && (mainData = CompletionUtil.getCompletionDataByFileType((FileType)fileType)) != null) {
            return mainData;
        }
        mainData = CompletionUtil.getCompletionDataByFileType(originalFile.getFileType());
        return mainData != null ? mainData : ourGenericCompletionData;
    }

    @Nullable
    private static CompletionData getCompletionDataByFileType(FileType fileType) {
        for (CompletionDataEP ep : CompletionDataEP.EP_NAME.getExtensionList()) {
            if (!ep.fileType.equals(fileType.getName())) continue;
            return ep.getHandler();
        }
        return null;
    }

    public static boolean shouldShowFeature(CompletionParameters parameters, @NonNls String id) {
        return CompletionUtil.shouldShowFeature(parameters.getPosition().getProject(), id);
    }

    public static boolean shouldShowFeature(Project project, @NonNls String id) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(id, project)) {
            FeatureUsageTracker.getInstance().triggerFeatureShown(id);
            return true;
        }
        return false;
    }

    public static String findJavaIdentifierPrefix(CompletionParameters parameters) {
        return CompletionUtil.findJavaIdentifierPrefix(parameters.getPosition(), parameters.getOffset());
    }

    public static String findJavaIdentifierPrefix(PsiElement insertedElement, int offset) {
        return CompletionUtil.findIdentifierPrefix(insertedElement, offset, (ElementPattern<Character>)CharPattern.javaIdentifierPartCharacter(), (ElementPattern<Character>)CharPattern.javaIdentifierStartCharacter());
    }

    public static String findReferenceOrAlphanumericPrefix(CompletionParameters parameters) {
        String prefix = CompletionUtil.findReferencePrefix(parameters);
        return prefix == null ? CompletionUtil.findAlphanumericPrefix(parameters) : prefix;
    }

    public static String findAlphanumericPrefix(CompletionParameters parameters) {
        return CompletionUtil.findIdentifierPrefix((PsiElement)parameters.getPosition().getContainingFile(), parameters.getOffset(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter());
    }

    public static String findIdentifierPrefix(PsiElement insertedElement, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        if (insertedElement == null) {
            return "";
        }
        String text = insertedElement.getText();
        int startOffset = insertedElement.getTextRange().getStartOffset();
        return CompletionUtil.findInText(offset, startOffset, idPart, idStart, text);
    }

    public static String findIdentifierPrefix(String wholeText, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        return CompletionUtil.findInText(offset, 0, idPart, idStart, wholeText);
    }

    public static String findIdentifierPrefix(@NotNull Document document, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        String text = document.getText();
        return CompletionUtil.findInText(offset, 0, idPart, idStart, text);
    }

    @NotNull
    private static String findInText(int offset, int startOffset, ElementPattern<Character> idPart, ElementPattern<Character> idStart, String text) {
        int start2;
        int offsetInElement = offset - startOffset;
        for (start2 = offsetInElement - 1; start2 >= 0 && idPart.accepts((Object)Character.valueOf(text.charAt(start2))); --start2) {
        }
        while (start2 + 1 < offsetInElement && !idStart.accepts((Object)Character.valueOf(text.charAt(start2 + 1)))) {
            ++start2;
        }
        return text.substring(start2 + 1, offsetInElement).trim();
    }

    @Nullable
    public static String findReferencePrefix(CompletionParameters parameters) {
        return CompletionData.getReferencePrefix(parameters.getPosition(), parameters.getOffset());
    }

    public static InsertionContext emulateInsertion(InsertionContext oldContext, int newStart, LookupElement item) {
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        return newContext;
    }

    private static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement) {
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor, oldContext.shouldAddCompletionChar());
    }

    public static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement, int startOffset, int tailOffset) {
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        return context;
    }

    public static void emulateInsertion(LookupElement item, int offset, InsertionContext context) {
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, (CharSequence)lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        item.handleInsert(context);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
    }

    private static void setOffsets(InsertionContext context, int offset, int tailOffset) {
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }

    @Nullable
    public static PsiElement getTargetElement(LookupElement lookupElement) {
        PsiElement element;
        PsiElement psiElement = lookupElement.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            return CompletionUtil.getOriginalElement(psiElement);
        }
        Object object = lookupElement.getObject();
        if (object instanceof LookupValueWithPsiElement && (element = ((LookupValueWithPsiElement)object).getElement()) != null && element.isValid()) {
            return CompletionUtil.getOriginalElement(element);
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        return CompletionUtilCoreImpl.getOriginalElement(psi);
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        T element = CompletionUtil.getOriginalElement(psi);
        return element == null ? psi : element;
    }

    public static LinkedHashSet<String> sortMatching(PrefixMatcher matcher, Collection<String> _names) {
        ProgressManager.checkCanceled();
        if (matcher.getPrefix().isEmpty()) {
            return ContainerUtil.newLinkedHashSet(_names);
        }
        ArrayList<String> sorted = new ArrayList<String>();
        for (String name : _names) {
            if (!matcher.prefixMatches(name)) continue;
            sorted.add(name);
        }
        ProgressManager.checkCanceled();
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        ProgressManager.checkCanceled();
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (String name : sorted) {
            if (!matcher.isStartMatch(name)) continue;
            result2.add(name);
        }
        ProgressManager.checkCanceled();
        result2.addAll(sorted);
        return result2;
    }

    public static Iterable<String> iterateLookupStrings(final @NotNull LookupElement element) {
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator original = element.getAllLookupStrings().iterator();
                return new UnmodifiableIterator<String>(original){

                    public boolean hasNext() {
                        try {
                            return super.hasNext();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    public String next() {
                        try {
                            return (String)super.next();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    private RuntimeException handleCME(ConcurrentModificationException cme) {
                        RuntimeExceptionWithAttachments ewa = new RuntimeExceptionWithAttachments("Error while traversing lookup strings of " + element + " of " + element.getClass(), (String)null, new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
                        ewa.initCause((Throwable)cme);
                        return ewa;
                    }
                };
            }
        };
    }
}

