/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.XmlClosingTagInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TagNameReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static LookupElement[] getTagNameVariants(@NotNull XmlTag tag, String prefix) {
        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
        for (XmlTagNameProvider tagNameProvider : XmlTagNameProvider.EP_NAME.getExtensionList()) {
            tagNameProvider.addTagNameVariants(elements, tag, prefix);
        }
        return elements.toArray(LookupElement.EMPTY_ARRAY);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        LegacyCompletionContributor.processReferences(parameters, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, set2) -> {
            TagNameReference tagNameReference;
            if (reference instanceof TagNameReference) {
                TagNameReferenceCompletionProvider.collectCompletionVariants((TagNameReference)reference, (Consumer<? super LookupElement>)set2);
            } else if (reference instanceof SchemaPrefixReference && (tagNameReference = ((SchemaPrefixReference)reference).getTagNameReference()) != null && !tagNameReference.isStartTagFlag()) {
                set2.consume(TagNameReferenceCompletionProvider.createClosingTagLookupElements((XmlTag)tagNameReference.getElement(), true, tagNameReference.getNameElement()).get(0));
            }
        }));
    }

    public static void collectCompletionVariants(TagNameReference tagNameReference, Consumer<? super LookupElement> consumer) {
        block4: {
            PsiElement element = tagNameReference.getElement();
            if (!(element instanceof XmlTag)) break block4;
            if (!tagNameReference.isStartTagFlag()) {
                for (LookupElement variant : TagNameReferenceCompletionProvider.createClosingTagLookupElements((XmlTag)element, false, tagNameReference.getNameElement())) {
                    consumer.consume((Object)variant);
                }
            } else {
                XmlTag tag = (XmlTag)element;
                for (LookupElement variant : TagNameReferenceCompletionProvider.getTagNameVariants(tag, tag.getNamespacePrefix())) {
                    consumer.consume((Object)variant);
                }
            }
        }
    }

    public static List<LookupElement> createClosingTagLookupElements(XmlTag tag, boolean includePrefix, ASTNode nameElement) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        while (tag != null) {
            LookupElementBuilder builder2 = LookupElementBuilder.create((String)(includePrefix || !nameElement.getText().contains(":") ? tag.getName() : tag.getLocalName()));
            result2.add((LookupElement)LookupElementDecorator.withInsertHandler(TailTypeDecorator.withTail(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder2), TailType.createSimpleTailType((char)'>')), (InsertHandler)XmlClosingTagInsertHandler.INSTANCE));
            if (!includePrefix && ((tag = tag.getParentTag()) == null || XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag.getNode()) == null && XmlChildRole.START_TAG_START_FINDER.findChild(tag.getNode()) != null)) continue;
            break;
        }
        return result2;
    }
}

