/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.IntStack;
import com.intellij.util.graph.Graph;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)ControlFlowUtil.class.getName());

    private ControlFlowUtil() {
    }

    @NotNull
    public static Graph<Instruction> createGraph(final @NotNull Instruction[] flow) {
        return new Graph<Instruction>(){
            @NotNull
            private final List<Instruction> myList;
            {
                this.myList = Arrays.asList(flow);
            }

            @NotNull
            public Collection<Instruction> getNodes() {
                return this.myList;
            }

            @NotNull
            public Iterator<Instruction> getIn(Instruction n) {
                return n.allPred().iterator();
            }

            @NotNull
            public Iterator<Instruction> getOut(Instruction n) {
                return n.allSucc().iterator();
            }
        };
    }

    public static int findInstructionNumberByElement(Instruction[] flow, PsiElement element) {
        for (int i = 0; i < flow.length; ++i) {
            ProgressManager.checkCanceled();
            if (element != flow[i].getElement()) continue;
            return i;
        }
        return -1;
    }

    public static boolean process(Instruction[] flow, int start2, Processor<? super Instruction> processor2) {
        int length = flow.length;
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        IntStack stack = new IntStack(length);
        stack.push(start2);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instruction = flow[num];
            if (!processor2.process((Object)instruction)) {
                return false;
            }
            for (Instruction succ : instruction.allSucc()) {
                int succNum = succ.num();
                if (visited[succNum]) continue;
                visited[succNum] = true;
                stack.push(succNum);
            }
        }
        return true;
    }

    public static void iteratePrev(int startInstruction, @NotNull Instruction[] instructions, @NotNull Function<? super Instruction, Operation> closure) {
        ControlFlowUtil.iterate(startInstruction, instructions, closure, true);
    }

    public static void iterate(int startInstruction, @NotNull Instruction[] instructions, @NotNull Function<? super Instruction, Operation> closure, boolean prev2) {
        IntStack stack = new IntStack(instructions.length);
        boolean[] visited = new boolean[instructions.length];
        stack.push(startInstruction);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instr = instructions[num];
            Operation nextOperation = (Operation)((Object)closure.fun((Object)instr));
            if (nextOperation == Operation.CONTINUE) continue;
            if (nextOperation == Operation.BREAK) break;
            assert (nextOperation == Operation.NEXT);
            Collection nextToProcess = prev2 ? instr.allPred() : instr.allSucc();
            for (Instruction pred : nextToProcess) {
                int predNum = pred.num();
                if (visited[predNum]) continue;
                visited[predNum] = true;
                stack.push(predNum);
            }
        }
    }

    public static enum Operation {
        CONTINUE,
        BREAK,
        NEXT;

    }
}

