/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow.impl;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.InstructionBaseImpl;
import com.intellij.psi.PsiElement;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachedInstructionImpl
extends InstructionBaseImpl {
    private final AtomicInteger myNum = new AtomicInteger(-1);

    public DetachedInstructionImpl(@Nullable PsiElement element) {
        super(element);
    }

    public int num() {
        return this.myNum.get();
    }

    public final void addToInstructions(@NotNull ControlFlowBuilder builder2) {
        assert (!(this instanceof TransparentInstruction));
        builder2.instructions.add(this);
        this.updateNum(builder2.instructionCount++);
    }

    public final void addTransparentNode(@NotNull ControlFlowBuilder builder2) {
        assert (this instanceof TransparentInstruction);
        this.updateNum(builder2.transparentInstructionCount++);
        builder2.addNodeAndCheckPending(this);
    }

    public final void addNode(@NotNull ControlFlowBuilder builder2) {
        assert (!(this instanceof TransparentInstruction));
        this.updateNum(builder2.instructionCount++);
        builder2.addNodeAndCheckPending(this);
    }

    public void updateNum(int newNum) {
        assert (this.myNum.get() == -1);
        this.myNum.set(newNum);
    }
}

