/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DaemonCodeAnalyzerSettings", storages={@Storage(value="editor.codeinsight.xml")})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettingsImpl;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "", "()V", "clone", "getState", "isCodeHighlightingChanged", "", "oldSettings", "loadState", "", "state", "intellij.platform.lang.impl"})
public class DaemonCodeAnalyzerSettingsImpl
extends DaemonCodeAnalyzerSettings
implements PersistentStateComponent<Element>,
Cloneable {
    @Override
    public boolean isCodeHighlightingChanged(@NotNull DaemonCodeAnalyzerSettings oldSettings) {
        DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings = oldSettings;
        if (daemonCodeAnalyzerSettings == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl");
        }
        return !JDOMUtil.areElementsEqual((Element)((DaemonCodeAnalyzerSettingsImpl)daemonCodeAnalyzerSettings).getState(), (Element)this.getState());
    }

    @NotNull
    public DaemonCodeAnalyzerSettingsImpl clone() {
        DaemonCodeAnalyzerSettingsImpl settings = new DaemonCodeAnalyzerSettingsImpl();
        settings.setAutoReparseDelay(this.getAutoReparseDelay());
        settings.myShowAddImportHints = this.myShowAddImportHints;
        settings.SHOW_METHOD_SEPARATORS = this.SHOW_METHOD_SEPARATORS;
        settings.NO_AUTO_IMPORT_PATTERN = this.NO_AUTO_IMPORT_PATTERN;
        settings.setShowSmallIconsInGutter(this.isShowSmallIconsInGutter());
        return settings;
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        XmlSerializer.serializeObjectInto$default((Object)this, (Element)element, null, (int)4, null);
        String profile2 = ApplicationInspectionProfileManager.getInstanceImpl().getRootProfileName();
        if (Intrinsics.areEqual((Object)"Default", (Object)profile2) ^ true) {
            element.setAttribute("profile", profile2);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        com.intellij.util.xmlb.XmlSerializer.deserializeInto((Object)this, (Element)state);
        ApplicationInspectionProfileManager profileManager = ApplicationInspectionProfileManager.getInstanceImpl();
        profileManager.getConverter().storeEditorHighlightingProfile(state, new InspectionProfileImpl("EditorHighlightingSettings"));
        String string = state.getAttributeValue("profile");
        if (string == null) {
            string = "Default";
        }
        profileManager.setRootProfile(string);
    }
}

