/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationHolderImpl
extends SmartList<Annotation>
implements AnnotationHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl");
    private final AnnotationSession myAnnotationSession;
    private final boolean myBatchMode;

    public AnnotationHolderImpl(@NotNull AnnotationSession session2) {
        this(session2, false);
    }

    public AnnotationHolderImpl(@NotNull AnnotationSession session2, boolean batchMode) {
        this.myAnnotationSession = session2;
        this.myBatchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.myBatchMode;
    }

    public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.ERROR, elt.getTextRange(), message);
    }

    public Annotation createErrorAnnotation(@NotNull ASTNode node, String message) {
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.ERROR, node.getTextRange(), message);
    }

    public Annotation createErrorAnnotation(@NotNull TextRange range2, String message) {
        return this.createAnnotation(HighlightSeverity.ERROR, range2, message);
    }

    public Annotation createWarningAnnotation(@NotNull PsiElement elt, String message) {
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WARNING, elt.getTextRange(), message);
    }

    public Annotation createWarningAnnotation(@NotNull ASTNode node, String message) {
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WARNING, node.getTextRange(), message);
    }

    public Annotation createWarningAnnotation(@NotNull TextRange range2, String message) {
        return this.createAnnotation(HighlightSeverity.WARNING, range2, message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, elt.getTextRange(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, node.getTextRange(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull TextRange range2, String message) {
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, range2, message);
    }

    public Annotation createInfoAnnotation(@NotNull PsiElement elt, String message) {
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.INFORMATION, elt.getTextRange(), message);
    }

    public Annotation createInfoAnnotation(@NotNull ASTNode node, String message) {
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.INFORMATION, node.getTextRange(), message);
    }

    private void assertMyFile(PsiElement node) {
        if (node == null) {
            return;
        }
        PsiFile myFile = this.myAnnotationSession.getFile();
        PsiFile containingFile = node.getContainingFile();
        LOG.assertTrue(containingFile != null, (Object)node);
        VirtualFile containingVFile = containingFile.getVirtualFile();
        VirtualFile myVFile = myFile.getVirtualFile();
        if (!Comparing.equal((Object)containingVFile, (Object)myVFile)) {
            LOG.error("Annotation must be registered for an element inside '" + myFile + "' which is in '" + myVFile + "'.\nElement passed: '" + node + "' is inside the '" + containingFile + "' which is in '" + containingVFile + "'");
        }
    }

    public Annotation createInfoAnnotation(@NotNull TextRange range2, String message) {
        return this.createAnnotation(HighlightSeverity.INFORMATION, range2, message);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range2, @Nullable String message) {
        String tooltip = message == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
        return this.createAnnotation(severity, range2, message, tooltip);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range2, @Nullable String message, @Nullable String tooltip) {
        Annotation annotation = new Annotation(range2.getStartOffset(), range2.getEndOffset(), severity, message, tooltip);
        this.add(annotation);
        return annotation;
    }

    public boolean hasAnnotations() {
        return !this.isEmpty();
    }

    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        return this.myAnnotationSession;
    }
}

