/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectHighlightsUtil {
    private static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create((String)"com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil");
    private static final int STARTING_TREE_HEIGHT = 100;

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset) {
        return CollectHighlightsUtil.getElementsInRange(root, startOffset, endOffset, false);
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset, boolean includeAllParents) {
        PsiElement commonParent = CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset);
        if (commonParent == null) {
            return new ArrayList<PsiElement>();
        }
        List<PsiElement> list2 = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent = commonParent;
        while (parent != null && parent != root) {
            list2.add(parent);
            parent = includeAllParents ? parent.getParent() : null;
        }
        list2.add(root);
        return list2;
    }

    @NotNull
    private static List<PsiElement> getElementsToHighlight(@NotNull PsiElement parent, int startOffset, int endOffset) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        int currentOffset = parent.getTextRange().getStartOffset();
        Condition<PsiElement>[] filters = FiltersHolder.FILTERS;
        int offset = currentOffset;
        TIntStack starts = new TIntStack(100);
        Stack elements = new Stack(100);
        Stack children2 = new Stack(100);
        PsiElement element = parent;
        PsiElement child2 = PsiUtilCore.NULL_PSI_ELEMENT;
        while (true) {
            boolean startChildrenVisiting;
            ProgressIndicatorProvider.checkCanceled();
            for (Condition<PsiElement> filter : filters) {
                if (filter.value((Object)element)) continue;
                assert (child2 == PsiUtilCore.NULL_PSI_ELEMENT);
                child2 = null;
                break;
            }
            if (child2 == PsiUtilCore.NULL_PSI_ELEMENT) {
                startChildrenVisiting = true;
                child2 = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child2 == null) {
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (elements.isEmpty()) break;
                int start2 = starts.pop();
                if (startOffset <= start2 && offset <= endOffset) {
                    assert (element != null);
                    assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
                    result2.add(element);
                }
                element = (PsiElement)elements.pop();
                child2 = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push((Object)child2.getNextSibling());
            starts.push(offset);
            assert (element != null);
            assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
            elements.push((Object)element);
            element = child2;
            child2 = PsiUtilCore.NULL_PSI_ELEMENT;
        }
        return result2;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        if (commonParent == null) {
            LOG.error("No common parent for " + left + " and " + right + "; root: " + root + "; startOffset: " + startOffset + "; endOffset: " + endOffset);
        }
        LOG.assertTrue(commonParent.getTextRange() != null, (Object)commonParent);
        for (PsiElement parent = commonParent.getParent(); parent != null && commonParent.getTextRange().equals((Object)parent.getTextRange()); parent = parent.getParent()) {
            commonParent = parent;
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root, int offset) {
        if (root instanceof PsiFile) {
            return ((PsiFile)root).getViewProvider().findElementAt(offset, root.getLanguage());
        }
        return root.findElementAt(offset);
    }

    static /* synthetic */ ExtensionPointName access$000() {
        return EP_NAME;
    }

    static class FiltersHolder {
        static final Condition<PsiElement>[] FILTERS = (Condition[])CollectHighlightsUtil.access$000().getExtensions();

        FiltersHolder() {
        }
    }
}

