/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TraceableDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonProgressIndicator
extends AbstractProgressIndicatorBase
implements StandardProgressIndicator,
Disposable {
    private static boolean debug;
    private final TraceableDisposable myTraceableDisposable = new TraceableDisposable(debug);
    private volatile boolean myDisposed;
    private volatile Throwable myCancellationCause;

    @Override
    public synchronized void stop() {
        super.stop();
        this.cancel();
    }

    public synchronized void stopIfRunning() {
        if (this.isRunning()) {
            this.stop();
        } else {
            this.cancel();
        }
    }

    @Override
    public final void cancel() {
        if (this.isCanceled()) {
            return;
        }
        this.myTraceableDisposable.kill("Daemon Progress Canceled");
        super.cancel();
        Disposer.dispose((Disposable)this);
    }

    public void cancel(@NotNull Throwable cause) {
        if (this.isCanceled()) {
            return;
        }
        this.myCancellationCause = cause;
        this.myTraceableDisposable.killExceptionally(cause);
        super.cancel();
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled();
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
    }

    @Override
    @Nullable
    protected Throwable getCancellationTrace() {
        Throwable cause = this.myCancellationCause;
        return cause != null ? cause : super.getCancellationTrace();
    }

    @Override
    public void start() {
        assert (!this.isCanceled()) : "canceled";
        assert (!this.isRunning()) : "running";
        super.start();
    }

    public static void setDebug(boolean debug) {
        DaemonProgressIndicator.debug = debug;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + (debug ? "; " + this.myTraceableDisposable.getStackTrace() + "\n;" : "");
    }

    boolean isDisposed() {
        return this.myDisposed;
    }
}

