/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.actions.ShowErrorDescriptionAction;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DaemonTooltipRenderer
extends LineTooltipRenderer {
    @NonNls
    protected static final String END_MARKER = "<!-- end marker -->";

    DaemonTooltipRenderer(String text, Object[] comparable) {
        super(text, comparable);
    }

    DaemonTooltipRenderer(String text, int width, Object[] comparable) {
        super(text, width, comparable);
    }

    @Override
    protected void onHide(@NotNull JComponent contentComponent) {
        ShowErrorDescriptionAction.rememberCurrentWidth(contentComponent.getWidth());
    }

    @Override
    @NotNull
    protected String dressDescription(@NotNull Editor editor, @NotNull String tooltipText, boolean expand) {
        if (!expand) {
            return super.dressDescription(editor, tooltipText, false);
        }
        List<String> problems = this.getProblems(tooltipText);
        StringBuilder text = new StringBuilder();
        for (String problem : problems) {
            String ref = DaemonTooltipRenderer.getLinkRef(problem);
            if (ref != null) {
                String description = TooltipLinkHandlerEP.getDescription(ref, editor);
                if (description == null) continue;
                description = InspectionNodeInfo.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody((Html)new Html(description).setKeepFont(true)));
                text.append(this.getHtmlForProblemWithLink(problem)).append(END_MARKER).append("<p>").append("<span style=\"color:").append(ColorUtil.toHex((Color)this.getDescriptionTitleColor())).append("\">Inspection info:</span>").append(description).append("<hr size=1 noshade>");
                continue;
            }
            text.append(UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true))).append("<hr size=1 noshade>");
        }
        if (text.length() > 0) {
            return XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)text.toString(), (String)"<hr size=1 noshade>"));
        }
        return super.dressDescription(editor, tooltipText, true);
    }

    @NotNull
    protected List<String> getProblems(@NotNull String tooltipText) {
        return StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(tooltipText).setKeepFont(true)), (String)"<hr size=1 noshade>");
    }

    @NotNull
    protected String getHtmlForProblemWithLink(@NotNull String problem) {
        Html html = new Html(problem).setKeepFont(true);
        return UIUtil.getHtmlBody((Html)html).replace(DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0]));
    }

    @Nullable
    protected static String getLinkRef(@NonNls String text) {
        String ref;
        int quoteIdx;
        String linkWithRef = "<a href=\"";
        int linkStartIdx = text.indexOf("<a href=\"");
        if (linkStartIdx >= 0 && (quoteIdx = (ref = text.substring(linkStartIdx + "<a href=\"".length())).indexOf(34)) > 0) {
            return ref.substring(0, quoteIdx);
        }
        return null;
    }

    @NotNull
    protected Color getDescriptionTitleColor() {
        return JBColor.namedColor((String)"ToolTip.infoForeground", (Color)new JBColor(0x919191, 0x919191));
    }

    @Override
    @NotNull
    protected LineTooltipRenderer createRenderer(@Nullable String text, int width) {
        return new DaemonTooltipRenderer(text, width, this.getEqualityObjects());
    }
}

