/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficTooltipRendererImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;

    DaemonTooltipRendererProvider(Project project) {
        this.myProject = project;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            String text = tooltipObject.toString();
            if (!tooltips.add(text)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text);
        }
        if (!infos.isEmpty()) {
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i != 0) {
                    return i;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite = HighlightInfoComposite.create((List<? extends HighlightInfo>)infos);
            String string = composite.getToolTip();
            DaemonTooltipRenderer myRenderer = new DaemonTooltipRenderer(string, new Object[]{highlighters});
            if (bigRenderer != null) {
                myRenderer.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer;
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
        return new DaemonTooltipRenderer(text, new Object[]{text});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
        return new DaemonTooltipRenderer(text, width, new Object[]{text});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text, @Nullable TooltipAction action, int width) {
        if (action != null || Registry.is((String)"ide.tooltip.show.with.actions")) {
            Object[] objectArray;
            if (action == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = text;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = text;
                objectArray = objectArray3;
                objectArray3[1] = action;
            }
            return new DaemonTooltipWithActionRenderer(text, action, width, objectArray);
        }
        return ErrorStripTooltipRendererProvider.super.calcTooltipRenderer(text, action, width);
    }

    @Override
    @NotNull
    public TrafficTooltipRenderer createTrafficTooltipRenderer(@NotNull Runnable onHide, @NotNull Editor editor) {
        return new TrafficTooltipRendererImpl(onHide, editor);
    }
}

