/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private AnnotationHolderImpl myAnnotationHolder;
    private final HighlightErrorFilter[] myErrorFilters;
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private final CachedAnnotators myCachedAnnotators;

    DefaultHighlightVisitor(@NotNull Project project, @NotNull CachedAnnotators cachedAnnotators) {
        this(project, true, true, false, cachedAnnotators);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode, @NotNull CachedAnnotators cachedAnnotators) {
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myCachedAnnotators = cachedAnnotators;
        this.myErrorFilters = (HighlightErrorFilter[])HighlightErrorFilter.EP_NAME.getExtensions((AreaInstance)project);
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode);
        try {
            action.run();
        }
        finally {
            this.myAnnotationHolder.clear();
            this.myAnnotationHolder = null;
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element);
            }
        } else if (this.myRunAnnotators) {
            this.runAnnotators(element);
        }
        if (this.myAnnotationHolder.hasAnnotations()) {
            Iterator iterator = this.myAnnotationHolder.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                this.myHolder.add(HighlightInfo.fromAnnotation(annotation, null, this.myBatchMode));
            }
            this.myAnnotationHolder.clear();
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode, this.myCachedAnnotators);
    }

    private void runAnnotators(PsiElement element) {
        List<Annotator> annotators = this.myCachedAnnotators.get(element.getLanguage().getID());
        if (annotators.isEmpty()) {
            return;
        }
        boolean dumb = this.myDumbService.isDumb();
        for (int i = 0; i < annotators.size(); ++i) {
            Annotator annotator = annotators.get(i);
            if (dumb && !DumbService.isDumbAware((Object)annotator)) continue;
            ProgressManager.checkCanceled();
            annotator.annotate(element, (AnnotationHolder)this.myAnnotationHolder);
        }
    }

    private void visitErrorElement(PsiErrorElement element) {
        for (HighlightErrorFilter errorFilter : this.myErrorFilters) {
            if (errorFilter.shouldHighlightErrorElement(element)) continue;
            return;
        }
        HighlightInfo info = DefaultHighlightVisitor.createErrorElementInfo(element);
        this.myHolder.add(info);
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        HighlightInfo info = DefaultHighlightVisitor.createInfoWithoutFixes(element);
        if (info != null) {
            for (ErrorQuickFixProvider provider : ErrorQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerErrorQuickFix(element, info);
            }
        }
        return info;
    }

    private static HighlightInfo createInfoWithoutFixes(@NotNull PsiErrorElement element) {
        int end;
        int start2;
        String text;
        TextRange range2 = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range2.isEmpty()) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range2).descriptionAndTooltip(errorDescription).create();
        }
        int offset = range2.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage((PsiElement)element));
        String string = text = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text != null && !StringUtil.startsWithChar((CharSequence)text, (char)'\n') && !StringUtil.startsWithChar((CharSequence)text, (char)'\r')) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            builder2.descriptionAndTooltip(errorDescription);
            return builder2.create();
        }
        if (offset > 0) {
            start2 = offset;
            end = offset;
        } else {
            start2 = offset;
            end = offset < fileLength ? offset + 1 : offset;
        }
        HighlightInfo.Builder builder3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element, start2, end);
        builder3.descriptionAndTooltip(errorDescription);
        builder3.endOfLine();
        return builder3.create();
    }
}

