/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class EditorNotificationActions
implements IntentionMenuContributor {
    EditorNotificationActions() {
    }

    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        Project project = hostEditor.getProject();
        if (project == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (!(fileEditorManager instanceof FileEditorManagerImpl)) {
            return;
        }
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(hostEditor);
        List<JComponent> components = ((FileEditorManagerImpl)fileEditorManager).getTopComponents((FileEditor)fileEditor);
        for (JComponent component : components) {
            IntentionActionWithOptions action;
            if (!(component instanceof IntentionActionProvider) || (action = ((IntentionActionProvider)component).getIntentionAction()) == null) continue;
            intentions.notificationActionsToShow.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)action, action.getOptions(), null));
        }
    }
}

