/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class EditorTracker
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(EditorTracker.class);
    private final Project myProject;
    private final WindowManager myWindowManager;
    private final EditorFactory myEditorFactory;
    private final Map<Window, List<Editor>> myWindowToEditorsMap = new HashMap<Window, List<Editor>>();
    private final Map<Window, WindowAdapter> myWindowToWindowFocusListenerMap = new HashMap<Window, WindowAdapter>();
    private final Map<Editor, Window> myEditorToWindowMap = new HashMap<Editor, Window>();
    private List<Editor> myActiveEditors = Collections.emptyList();
    private final EventDispatcher<EditorTrackerListener> myDispatcher = EventDispatcher.create(EditorTrackerListener.class);
    private IdeFrameImpl myIdeFrame;
    private Window myActiveWindow;

    public EditorTracker(Project project, WindowManager windowManager, EditorFactory editorFactory) {
        this.myProject = project;
        this.myWindowManager = windowManager;
        this.myEditorFactory = editorFactory;
    }

    public void projectOpened() {
        this.myIdeFrame = ((WindowManagerEx)this.myWindowManager).getFrame(this.myProject);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (EditorTracker.this.myIdeFrame == null || EditorTracker.this.myIdeFrame.getFocusOwner() == null) {
                    return;
                }
                EditorTracker.this.setActiveWindow(EditorTracker.this.myIdeFrame);
            }
        });
        MyEditorFactoryListener myEditorFactoryListener = new MyEditorFactoryListener();
        this.myEditorFactory.addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, () -> myEditorFactoryListener.executeOnRelease(null));
    }

    private void editorFocused(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Window window = this.myEditorToWindowMap.get(editor);
        if (window == null) {
            return;
        }
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        int index = list2.indexOf(editor);
        LOG.assertTrue(index >= 0);
        if (list2.isEmpty()) {
            return;
        }
        for (int i = index - 1; i >= 0; --i) {
            list2.set(i + 1, list2.get(i));
        }
        list2.set(0, editor);
        this.setActiveWindow(window);
    }

    private void registerEditor(Editor editor) {
        this.unregisterEditor(editor);
        final Window window = this.windowByEditor(editor);
        if (window == null) {
            return;
        }
        this.myEditorToWindowMap.put(editor, window);
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            list2 = new ArrayList<Editor>();
            this.myWindowToEditorsMap.put(window, list2);
            if (!(window instanceof IdeFrameImpl)) {
                WindowAdapter listener2 = new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowGainedFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(window);
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowLostFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowClosed:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }
                };
                this.myWindowToWindowFocusListenerMap.put(window, listener2);
                window.addWindowFocusListener(listener2);
                window.addWindowListener(listener2);
                if (window.isFocused()) {
                    this.setActiveWindow(window);
                }
            }
        }
        list2.add(editor);
        if (this.myActiveWindow == window) {
            this.setActiveWindow(window);
        }
    }

    private void unregisterEditor(Editor editor) {
        Window oldWindow = this.myEditorToWindowMap.get(editor);
        if (oldWindow != null) {
            this.myEditorToWindowMap.remove(editor);
            List<Editor> editorsList = this.myWindowToEditorsMap.get(oldWindow);
            boolean removed = editorsList.remove(editor);
            LOG.assertTrue(removed);
            if (editorsList.isEmpty()) {
                this.myWindowToEditorsMap.remove(oldWindow);
                WindowAdapter listener2 = this.myWindowToWindowFocusListenerMap.remove(oldWindow);
                if (listener2 != null) {
                    oldWindow.removeWindowFocusListener(listener2);
                    oldWindow.removeWindowListener(listener2);
                }
            }
        }
    }

    private Window windowByEditor(Editor editor) {
        Window window = SwingUtilities.windowForComponent(editor.getComponent());
        if (window instanceof IdeFrameImpl && window != this.myIdeFrame) {
            return null;
        }
        return window;
    }

    @NotNull
    public List<Editor> getActiveEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myActiveEditors;
    }

    private void setActiveWindow(Window window) {
        this.myActiveWindow = window;
        List<Editor> editors = this.editorsByWindow(this.myActiveWindow);
        this.setActiveEditors(editors);
    }

    @NotNull
    private List<Editor> editorsByWindow(Window window) {
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            return Collections.emptyList();
        }
        SmartList filtered = new SmartList();
        for (Editor editor : list2) {
            if (!editor.getContentComponent().isShowing()) continue;
            filtered.add(editor);
        }
        return filtered;
    }

    public void setActiveEditors(@NotNull List<Editor> editors) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActiveEditors = editors;
        if (LOG.isDebugEnabled()) {
            LOG.debug("active editors changed:");
            for (Editor editor : editors) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                LOG.debug("    " + psiFile);
            }
        }
        ((EditorTrackerListener)this.myDispatcher.getMulticaster()).activeEditorsChanged(editors);
    }

    void addEditorTrackerListener(@NotNull Disposable parentDisposable, @NotNull EditorTrackerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private class MyEditorFactoryListener
    implements EditorFactoryListener {
        private final Map<Editor, Runnable> myExecuteOnEditorRelease = new HashMap<Editor, Runnable>();

        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            final Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != EditorTracker.this.myProject || EditorTracker.this.myProject.isDisposed()) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)EditorTracker.this.myProject).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return;
            }
            JComponent component = editor.getComponent();
            JComponent contentComponent = editor.getContentComponent();
            HierarchyListener hierarchyListener = __ -> EditorTracker.this.registerEditor(editor);
            component.addHierarchyListener(hierarchyListener);
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(@NotNull FocusEvent e) {
                    EditorTracker.this.editorFocused(editor);
                }

                @Override
                public void focusLost(@NotNull FocusEvent e) {
                }
            };
            contentComponent.addFocusListener(focusListener);
            this.myExecuteOnEditorRelease.put(event.getEditor(), () -> {
                component.removeHierarchyListener(hierarchyListener);
                contentComponent.removeFocusListener(focusListener);
            });
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != EditorTracker.this.myProject) {
                return;
            }
            EditorTracker.this.unregisterEditor(editor);
            this.executeOnRelease(editor);
        }

        private void executeOnRelease(Editor editor) {
            if (editor == null) {
                for (Runnable r : this.myExecuteOnEditorRelease.values()) {
                    r.run();
                }
                this.myExecuteOnEditorRelease.clear();
            } else {
                Runnable runnable2 = this.myExecuteOnEditorRelease.get(editor);
                if (runnable2 != null) {
                    runnable2.run();
                    this.myExecuteOnEditorRelease.remove(editor);
                }
            }
        }
    }
}

