/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorStripeUpdateManager {
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public static ErrorStripeUpdateManager getInstance(Project project) {
        return (ErrorStripeUpdateManager)ServiceManager.getService((Project)project, ErrorStripeUpdateManager.class);
    }

    public ErrorStripeUpdateManager(Project project, PsiDocumentManager psiDocumentManager) {
        this.myProject = project;
        this.myPsiDocumentManager = psiDocumentManager;
    }

    public void repaintErrorStripePanel(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isInitialized()) {
            return;
        }
        PsiFile file2 = this.myPsiDocumentManager.getPsiFile(editor.getDocument());
        EditorMarkupModel markup = (EditorMarkupModel)editor.getMarkupModel();
        markup.setErrorPanelPopupHandler(ErrorStripeUpdateManager.createPopup(file2));
        markup.setErrorStripTooltipRendererProvider(this.createTooltipRenderer());
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.setOrRefreshErrorStripeRenderer(markup, file2);
    }

    protected void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @Nullable PsiFile file2) {
        Editor editor;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || !DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer2 = editorMarkupModel.getErrorStripeRenderer();
        if (renderer2 instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer2;
            EditorMarkupModelImpl markupModelImpl = (EditorMarkupModelImpl)editorMarkupModel;
            tlr.refresh(markupModelImpl);
            markupModelImpl.repaintVerticalScrollBar();
            if (tlr.isValid()) {
                return;
            }
        }
        if ((editor = editorMarkupModel.getEditor()).isDisposed()) {
            return;
        }
        editorMarkupModel.setErrorStripeRenderer(this.createRenderer(editor, file2));
    }

    @NotNull
    private static PopupHandler createPopup(@Nullable PsiFile psiFile) {
        return new DaemonEditorPopup(psiFile);
    }

    @NotNull
    private ErrorStripTooltipRendererProvider createTooltipRenderer() {
        return new DaemonTooltipRendererProvider(this.myProject);
    }

    @Nullable
    protected TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile file2) {
        for (TrafficLightRendererContributor contributor : TrafficLightRendererContributor.EP_NAME.getExtensionList()) {
            TrafficLightRenderer renderer2 = contributor.createRenderer(editor, file2);
            if (renderer2 == null) continue;
            return renderer2;
        }
        return new TrafficLightRenderer(this.myProject, editor.getDocument(), file2);
    }
}

