/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ExternalToolPass.class);
    private final Document myDocument;
    private final AnnotationHolderImpl myAnnotationHolder;
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;
    private final List<MyData> myAnnotationData = new ArrayList<MyData>();

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Editor editor, int startOffset, int endOffset) {
        this(factory, file2, editor.getDocument(), editor, startOffset, endOffset, new DefaultHighlightInfoProcessor(), false);
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Document document, @Nullable Editor editor, int startOffset, int endOffset, @NotNull HighlightInfoProcessor processor2, boolean mainHighlightingPass) {
        super(file2.getProject(), document, "External annotators", file2, editor, new TextRange(startOffset, endOffset), false, processor2);
        this.myDocument = document;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = factory;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        HighlightingLevelManager highlightingManager = HighlightingLevelManager.getInstance(this.myProject);
        HashMap<PsiFile, List> allAnnotators = new HashMap<PsiFile, List>();
        int externalAnnotatorsInRoots = 0;
        for (Language language : viewProvider.getLanguages()) {
            List annotators;
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!highlightingManager.shouldInspect((PsiElement)psiRoot) || (annotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot)).isEmpty()) continue;
            externalAnnotatorsInRoots += annotators.size();
            allAnnotators.put(psiRoot, annotators);
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        boolean errorFound = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().wasErrorFound(this.myDocument);
        Editor editor = this.getEditor();
        for (PsiFile psiRoot : allAnnotators.keySet()) {
            for (ExternalAnnotator annotator : (List)allAnnotators.get(psiRoot)) {
                String shortName = annotator.getPairedBatchInspectionShortName();
                if (shortName != null) {
                    HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
                    LOG.assertTrue(key != null || ApplicationManager.getApplication().isUnitTestMode(), (Object)("Paired tool '" + shortName + "' not found for external annotator: " + annotator));
                    if (key == null || !profile2.isToolEnabled(key, (PsiElement)this.myFile)) continue;
                }
                Object collectedInfo = null;
                try {
                    collectedInfo = editor != null ? annotator.collectInformation(psiRoot, editor, errorFound) : annotator.collectInformation(psiRoot);
                }
                catch (Throwable t) {
                    ExternalToolPass.process(t, annotator, psiRoot);
                }
                this.advanceProgress(1L);
                if (collectedInfo == null) continue;
                this.myAnnotationData.add(new MyData(annotator, psiRoot, collectedInfo));
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.doApply();
            return this.getHighlights();
        }
        return super.getInfos();
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            public void run() {
                if (!ExternalToolPass.this.documentChanged(modificationStampBefore) && !ExternalToolPass.this.myProject.isDisposed()) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ExternalToolPass.this.myProject, () -> {
                        ExternalToolPass.this.doAnnotate();
                        ReadAction.run(() -> {
                            ProgressManager.checkCanceled();
                            if (!ExternalToolPass.this.documentChanged(modificationStampBefore)) {
                                ExternalToolPass.this.doApply();
                                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                            }
                        });
                    });
                }
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    private void doAnnotate() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        for (MyData data : this.myAnnotationData) {
            if (dumbService.isDumb() && !DumbService.isDumbAware((Object)data.annotator)) continue;
            try {
                data.annotationResult = data.annotator.doAnnotate(data.collectedInfo);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data.annotator, data.psiRoot);
            }
        }
    }

    private void doApply() {
        for (MyData data : this.myAnnotationData) {
            if (data.annotationResult == null || data.psiRoot == null || !data.psiRoot.isValid()) continue;
            try {
                data.annotator.apply(data.psiRoot, data.annotationResult, (AnnotationHolder)this.myAnnotationHolder);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data.annotator, data.psiRoot);
            }
        }
    }

    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        Iterator iterator = this.myAnnotationHolder.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        return infos;
    }

    private void doFinish(List<HighlightInfo> highlights, long modificationStampBefore) {
        Editor editor = this.getEditor();
        assert (editor != null);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.documentChanged(modificationStampBefore) && !this.myProject.isDisposed()) {
                int start2 = this.myRestrictRange.getStartOffset();
                int end = this.myRestrictRange.getEndOffset();
                UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, start2, end, highlights, this.getColorsScheme(), this.getId());
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }

    private static void process(Throwable t, ExternalAnnotator annotator, PsiFile root) {
        if (t instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)t;
        }
        VirtualFile file2 = root.getVirtualFile();
        String path = file2 != null ? file2.getPath() : root.getName();
        PluginException pluginException = PluginException.createByClass((String)("annotator: " + annotator + " (" + annotator.getClass() + ")"), (Throwable)t, annotator.getClass());
        LOG.error("ExternalToolPass: ", (Throwable)pluginException, new Attachment[]{new Attachment("root_path.txt", path)});
    }

    private static class MyData {
        private final ExternalAnnotator annotator;
        private final PsiFile psiRoot;
        private final Object collectedInfo;
        private volatile Object annotationResult;

        private MyData(ExternalAnnotator annotator, PsiFile psiRoot, Object collectedInfo) {
            this.annotator = annotator;
            this.psiRoot = psiRoot;
            this.collectedInfo = collectedInfo;
        }
    }
}

