/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ExternalToolPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPassFactory
implements TextEditorHighlightingPassFactory,
MainHighlightingPassFactory {
    private final MergingUpdateQueue myExternalActivitiesQueue;

    public ExternalToolPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, 8);
        this.myExternalActivitiesQueue = new MergingUpdateQueue("ExternalActivitiesQueue", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project, null, false);
        this.myExternalActivitiesQueue.setPassThrough(ApplicationManager.getApplication().isUnitTestMode());
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange;
        TextRange textRange2 = textRange = FileStatusMap.getDirtyTextRange(editor, 8) == null ? null : file2.getTextRange();
        if (textRange == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, editor, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static boolean externalAnnotatorsDefined(@NotNull PsiFile file2) {
        for (Language language : file2.getViewProvider().getLanguages()) {
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)file2);
            if (externalAnnotators.isEmpty()) continue;
            return true;
        }
        return false;
    }

    void scheduleExternalActivity(@NotNull Update update) {
        this.myExternalActivitiesQueue.queue(update);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange range2 = file2.getTextRange();
        if (range2 == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, document, null, range2.getStartOffset(), range2.getEndOffset(), highlightInfoProcessor, true);
    }
}

