/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightersRecycler {
    private final MultiMap<TextRange, RangeHighlighter> incinerator = MultiMap.createSmart();

    HighlightersRecycler() {
    }

    void recycleHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter.isValid()) {
            this.incinerator.putValue((Object)ProperTextRange.create((Segment)highlighter), (Object)highlighter);
        }
    }

    @Nullable
    RangeHighlighter pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer) {
        TextRange range2 = new TextRange(startOffset, endOffset);
        Collection collection = this.incinerator.get((Object)range2);
        for (RangeHighlighter highlighter : collection) {
            if (!highlighter.isValid() || highlighter.getLayer() != layer) continue;
            this.incinerator.remove((Object)range2, (Object)highlighter);
            return highlighter;
        }
        return null;
    }

    @NotNull
    Collection<? extends RangeHighlighter> forAllInGarbageBin() {
        return this.incinerator.values();
    }
}

