/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.google.wireless.android.sdk.stats.EditorHighlightingStats;
import com.intellij.codeInsight.daemon.impl.HighlightingStats;
import com.intellij.codeInsight.daemon.impl.HighlightingStats$sam$java_lang_Runnable$0;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.analytics.HistogramUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HighlightingStats;", "Lcom/intellij/openapi/components/BaseComponent;", "()V", "MAX_LATENCY_MS", "", "latencyRecorders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "Lorg/HdrHistogram/Recorder;", "convertFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "initComponent", "", "recordHighlightingLatency", "document", "Lcom/intellij/openapi/editor/Document;", "latencyMs", "", "reportHighlightingStats", "intellij.platform.analysis.impl"})
public final class HighlightingStats
implements BaseComponent {
    private static final int MAX_LATENCY_MS = 600000;
    private static final ConcurrentHashMap<EditorFileType, Recorder> latencyRecorders;
    public static final HighlightingStats INSTANCE;

    public void initComponent() {
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((HighlightingStats)this.receiver).reportHighlightingStats();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(HighlightingStats.class);
            }

            public final String getName() {
                return "reportHighlightingStats";
            }

            public final String getSignature() {
                return "reportHighlightingStats()V";
            }
        };
        JobScheduler.getScheduler().scheduleWithFixedDelay(new HighlightingStats$sam$java_lang_Runnable$0(function0), 1L, 1L, TimeUnit.HOURS);
    }

    public final void recordHighlightingLatency(@NotNull Document document, long latencyMs) {
        if (latencyMs < 0L || latencyMs > (long)600000) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        EditorFileType fileType = this.convertFileType(file2);
        Recorder recorder2 = latencyRecorders.computeIfAbsent(fileType, recordHighlightingLatency.recorder.1.INSTANCE);
        recorder2.recordValue(latencyMs);
    }

    public final void reportHighlightingStats() {
        AndroidStudioEvent.Builder builder2;
        EditorHighlightingStats.Builder allStats = EditorHighlightingStats.newBuilder();
        Map map2 = latencyRecorders;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            EditorHighlightingStats.Stats.Builder builder3;
            AndroidStudioEvent.Builder builder4 = builder2 = iterator.next();
            EditorFileType fileType = (EditorFileType)builder4.getKey();
            builder4 = builder2;
            Recorder recorder2 = (Recorder)builder4.getValue();
            Histogram histogram = recorder2.getIntervalHistogram();
            if (histogram.getTotalCount() == 0L) continue;
            EditorHighlightingStats.Stats.Builder it = builder3 = EditorHighlightingStats.Stats.newBuilder();
            boolean bl = false;
            it.setFileType(fileType);
            it.setHistogram(HistogramUtil.toProto((Histogram)histogram));
            EditorHighlightingStats.Stats.Builder record = builder3;
            allStats.addByFileType(record.build());
        }
        if (allStats.getByFileTypeCount() == 0) {
            return;
        }
        AndroidStudioEvent.Builder $receiver = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $receiver.setKind(AndroidStudioEvent.EventKind.EDITOR_HIGHLIGHTING_STATS);
        $receiver.setEditorHighlightingStats(allStats.build());
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
    }

    private final EditorFileType convertFileType(VirtualFile file2) {
        EditorFileType editorFileType;
        switch (file2.getFileType().getName()) {
            case "JAVA": {
                editorFileType = EditorFileType.JAVA;
                break;
            }
            case "Kotlin": {
                if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kts")) {
                    editorFileType = EditorFileType.KOTLIN_SCRIPT;
                    break;
                }
                editorFileType = EditorFileType.KOTLIN;
                break;
            }
            case "XML": {
                editorFileType = EditorFileType.XML;
                break;
            }
            case "Groovy": {
                editorFileType = EditorFileType.GROOVY;
                break;
            }
            case "Properties": {
                editorFileType = EditorFileType.PROPERTIES;
                break;
            }
            case "JSON": {
                editorFileType = EditorFileType.JSON;
                break;
            }
            case "ObjectiveC": {
                editorFileType = EditorFileType.NATIVE;
                break;
            }
            default: {
                editorFileType = EditorFileType.UNKNOWN;
            }
        }
        return editorFileType;
    }

    private HighlightingStats() {
    }

    static {
        HighlightingStats highlightingStats;
        INSTANCE = highlightingStats = new HighlightingStats();
        latencyRecorders = new ConcurrentHashMap();
    }
}

