/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LineMarkersPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LineMarkersPass");
    private volatile List<LineMarkerInfo<PsiElement>> myMarkers = Collections.emptyList();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myPriorityBounds;
    @NotNull
    private final TextRange myRestrictRange;

    LineMarkersPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange priorityBounds, @NotNull TextRange restrictRange) {
        super(project, document, false);
        this.myFile = file2;
        this.myPriorityBounds = priorityBounds;
        this.myRestrictRange = restrictRange;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return super.getDocument();
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myRestrictRange, this.myMarkers, this.getId());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        ArrayList<LineMarkerInfo<PsiElement>> lineMarkers = new ArrayList<LineMarkerInfo<PsiElement>>();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myProject);
            if (!highlightingLevelManager.shouldHighlight((PsiElement)root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, this.myRestrictRange, this.myPriorityBounds, (Processor<? super Divider.DividedElements>)((Processor)elements -> {
                List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
                ArrayList<LineMarkerProvider> providersList = new ArrayList<LineMarkerProvider>(providers);
                LineMarkersPass.queryProviders(elements.inside, root, providersList, (PairConsumer<? super PsiElement, ? super LineMarkerInfo<PsiElement>>)((PairConsumer)(element, info) -> {
                    lineMarkers.add((LineMarkerInfo<PsiElement>)info);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isValid()) {
                            LineMarkersUtil.addLineMarkerToEditorIncrementally(this.myProject, this.getDocument(), info);
                        }
                    }, this.myProject.getDisposed());
                }));
                LineMarkersPass.queryProviders(elements.outside, root, providersList, (PairConsumer<? super PsiElement, ? super LineMarkerInfo<PsiElement>>)((PairConsumer)(element, info) -> lineMarkers.add((LineMarkerInfo<PsiElement>)info)));
                return true;
            }));
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersPass.doCollectInformation. lineMarkers: " + lineMarkers + "; merged: " + this.myMarkers);
        }
    }

    @NotNull
    private static List<LineMarkerInfo<PsiElement>> mergeLineMarkers(@NotNull List<LineMarkerInfo<PsiElement>> markers, @NotNull Document document) {
        ArrayList<MergeableLineMarkerInfo> forMerge = new ArrayList<MergeableLineMarkerInfo>();
        TIntObjectHashMap sameLineMarkers = new TIntObjectHashMap();
        for (int i = markers.size() - 1; i >= 0; --i) {
            LineMarkerInfo<PsiElement> marker = markers.get(i);
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            MergeableLineMarkerInfo mergeable = (MergeableLineMarkerInfo)marker;
            forMerge.add(mergeable);
            markers.remove(i);
            int line = document.getLineNumber(marker.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos2 = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos2 == null) {
                infos2 = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos2);
            }
            infos2.add(mergeable);
        }
        if (forMerge.isEmpty()) {
            return markers;
        }
        ArrayList<LineMarkerInfo<PsiElement>> result2 = new ArrayList<LineMarkerInfo<PsiElement>>(markers);
        sameLineMarkers.forEachValue(infos -> result2.addAll(MergeableLineMarkerInfo.merge((List)infos)));
        return result2;
    }

    @NotNull
    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language, @NotNull Project project) {
        List forLanguage = LineMarkerProviders.INSTANCE.allForLanguageOrAny(language);
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)forLanguage);
        LineMarkerSettings settings = LineMarkerSettings.getSettings();
        return ContainerUtil.filter((Collection)providers, provider -> !(provider instanceof LineMarkerProviderDescriptor) || settings.isEnabled((GutterIconDescriptor)((LineMarkerProviderDescriptor)provider)));
    }

    private static void queryProviders(@NotNull List<PsiElement> elements, @NotNull PsiFile containingFile, @NotNull List<? extends LineMarkerProvider> providers, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<PsiElement>> consumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet visitedInjectedFiles = new THashSet();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            for (int j = 0; j < providers.size(); ++j) {
                LineMarkerInfo info;
                ProgressManager.checkCanceled();
                LineMarkerProvider provider = providers.get(j);
                try {
                    info = provider.getLineMarkerInfo(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("During querying provider " + provider + " (" + provider.getClass() + ")", (Throwable)e);
                    continue;
                }
                if (info == null) continue;
                consumer.consume((Object)element, (Object)info);
            }
            LineMarkersPass.queryLineMarkersForInjected(element, containingFile, (Set<? super PsiFile>)visitedInjectedFiles, consumer);
        }
        NotNullList slowLineMarkers = new NotNullList();
        for (int j = 0; j < providers.size(); ++j) {
            ProgressManager.checkCanceled();
            LineMarkerProvider provider = providers.get(j);
            try {
                provider.collectSlowLineMarkers(elements, (Collection)slowLineMarkers);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (slowLineMarkers.isEmpty()) continue;
            for (int k = 0; k < slowLineMarkers.size(); ++k) {
                LineMarkerInfo slowInfo = (LineMarkerInfo)slowLineMarkers.get(k);
                PsiElement element = slowInfo.getElement();
                consumer.consume((Object)element, (Object)slowInfo);
            }
            slowLineMarkers.clear();
        }
    }

    private static void queryLineMarkersForInjected(@NotNull PsiElement element, @NotNull PsiFile containingFile, @NotNull Set<? super PsiFile> visitedInjectedFiles, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<PsiElement>> consumer) {
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element, containingFile, false, (injectedPsi, places) -> {
            if (!visitedInjectedFiles.add(injectedPsi)) {
                return;
            }
            Project project = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project);
            LineMarkersPass.queryProviders(injElements, injectedPsi, providers, (PairConsumer<? super PsiElement, ? super LineMarkerInfo<PsiElement>>)((PairConsumer)(injectedElement, injectedMarker) -> {
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    GutterIconNavigationHandler navigationHandler = injectedMarker.getNavigationHandler();
                    LineMarkerInfo converted = new LineMarkerInfo(injectedElement, hostRange, icon, injectedMarker.updatePass, e -> injectedMarker.getLineMarkerTooltip(), navigationHandler, GutterIconRenderer.Alignment.RIGHT);
                    consumer.consume(injectedElement, (Object)converted);
                }
            }));
        });
    }

    @NotNull
    public static Collection<LineMarkerInfo<PsiElement>> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2.getNode() == null) {
            return Collections.emptyList();
        }
        LineMarkersPass pass = new LineMarkersPass(file2.getProject(), file2, document, file2.getTextRange(), file2.getTextRange());
        pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        return pass.myMarkers;
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme2 = colorsManager.getGlobalScheme();
        info.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    @Override
    public String toString() {
        return super.toString() + "; myBounds: " + this.myPriorityBounds;
    }
}

