/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineMarkersUtil {
    private static final Logger LOG = Logger.getInstance(LineMarkersUtil.class);
    private static final Key<LineMarkerInfo> LINE_MARKER_INFO = Key.create((String)"LINE_MARKER_INFO");

    LineMarkersUtil() {
    }

    static boolean processLineMarkers(@NotNull Project project, @NotNull Document document, @NotNull Segment bounds2, int group, @NotNull Processor<? super LineMarkerInfo> processor2) {
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        return markupModel.processRangeHighlightersOverlappingWith(bounds2.getStartOffset(), bounds2.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            LineMarkerInfo info = LineMarkersUtil.getLineMarkerInfo(highlighter);
            return info == null || group != -1 && info.updatePass != group || processor2.process((Object)info);
        }));
    }

    static void setLineMarkersToEditor(@NotNull Project project, @NotNull Document document, @NotNull Segment bounds2, @NotNull Collection<? extends LineMarkerInfo<PsiElement>> markers, int group) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        LineMarkersUtil.processLineMarkers(project, document, bounds2, group, (Processor<? super LineMarkerInfo>)((Processor)info -> {
            toReuse.recycleHighlighter(info.highlighter);
            return true;
        }));
        if (LOG.isDebugEnabled()) {
            List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project);
            LOG.debug("LineMarkersUtil.setLineMarkersToEditor(markers: " + markers + ", group: " + group + "); oldMarkers: " + oldMarkers + "; reused: " + toReuse.forAllInGarbageBin().size());
        }
        for (LineMarkerInfo<PsiElement> lineMarkerInfo : markers) {
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || !TextRange.containsRange((Segment)bounds2, (Segment)(elementRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost(element, textRange)))) continue;
            LineMarkersUtil.createOrReuseLineMarker(lineMarkerInfo, markupModel, toReuse);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
    }

    @NotNull
    private static RangeHighlighter createOrReuseLineMarker(@NotNull LineMarkerInfo info, @NotNull MarkupModelEx markupModel, @Nullable HighlightersRecycler toReuse) {
        LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)info.createGutterRenderer();
        RangeHighlighter highlighter = toReuse == null ? null : toReuse.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, 3000);
        boolean newHighlighter = false;
        if (highlighter == null) {
            newHighlighter = true;
            highlighter = markupModel.addRangeHighlighterAndChangeAttributes(info.startOffset, info.endOffset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE, false, (Consumer<RangeHighlighterEx>)((Consumer)markerEx -> {
                markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                markerEx.setLineSeparatorColor(info.separatorColor);
                markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                markerEx.putUserData(LINE_MARKER_INFO, info);
            }));
            MarkupEditorFilter editorFilter = info.getEditorFilter();
            if (editorFilter != MarkupEditorFilter.EMPTY) {
                highlighter.setEditorFilter(editorFilter);
            }
        }
        if (!newHighlighter) {
            boolean lineSeparatorPlacementChanged;
            highlighter.putUserData(LINE_MARKER_INFO, (Object)info);
            LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = highlighter.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)highlighter.getGutterIconRenderer() : null;
            boolean rendererChanged = newRenderer == null || !newRenderer.equals((Object)oldRenderer);
            boolean lineSeparatorColorChanged = !Comparing.equal((Object)highlighter.getLineSeparatorColor(), (Object)info.separatorColor);
            boolean bl = lineSeparatorPlacementChanged = !Comparing.equal((Object)highlighter.getLineSeparatorPlacement(), (Object)info.separatorPlacement);
            if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
                markupModel.changeAttributesInBatch((RangeHighlighterEx)highlighter, (Consumer<RangeHighlighterEx>)((Consumer)markerEx -> {
                    if (rendererChanged) {
                        markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                    }
                    if (lineSeparatorColorChanged) {
                        markerEx.setLineSeparatorColor(info.separatorColor);
                    }
                    if (lineSeparatorPlacementChanged) {
                        markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                    }
                }));
            }
        }
        info.highlighter = highlighter;
        return highlighter;
    }

    static void addLineMarkerToEditorIncrementally(@NotNull Project project, @NotNull Document document, @NotNull LineMarkerInfo marker) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        LineMarkerInfo[] markerInTheWay = new LineMarkerInfo[]{null};
        boolean allIsClear = markupModel.processRangeHighlightersOverlappingWith(marker.startOffset, marker.endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            markerInTheWay[0] = LineMarkersUtil.getLineMarkerInfo(highlighter);
            return markerInTheWay[0] == null;
        }));
        if (allIsClear) {
            LineMarkersUtil.createOrReuseLineMarker(marker, markupModel, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersUtil.addLineMarkerToEditorIncrementally: " + marker + " " + (allIsClear ? "created" : " (was not added because " + markerInTheWay[0] + " was in the way)"));
        }
    }

    private static LineMarkerInfo getLineMarkerInfo(@NotNull RangeHighlighter highlighter) {
        return (LineMarkerInfo)highlighter.getUserData(LINE_MARKER_INFO);
    }
}

