/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPassFactory
implements MainHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPassFactory.class);
    private final Project myProject;

    public LocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, 7);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange = LocalInspectionsPassFactory.calculateRangeToProcess(editor);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new MyLocalInspectionsPass(file2, editor.getDocument(), textRange, (TextRange)visibleRange, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange textRange = file2.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("textRange is null for " + file2 + " (" + PsiUtilCore.getVirtualFile((PsiElement)file2) + ")"));
        return new MyLocalInspectionsPass(file2, document, textRange, LocalInspectionsPass.EMPTY_PRIORITY_RANGE, highlightInfoProcessor);
    }

    private static TextRange calculateRangeToProcess(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 7);
    }

    private static class MyLocalInspectionsPass
    extends LocalInspectionsPass {
        private MyLocalInspectionsPass(@NotNull PsiFile file2, Document document, @NotNull TextRange textRange, @NotNull TextRange visibleRange, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            super(file2, document, textRange.getStartOffset(), textRange.getEndOffset(), visibleRange, true, highlightInfoProcessor, true);
        }

        @Override
        @NotNull
        List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
            List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile2);
            ArrayList<LocalInspectionToolWrapper> result2 = new ArrayList<LocalInspectionToolWrapper>(tools.size());
            for (LocalInspectionToolWrapper tool : tools) {
                if (tool.runForWholeFile()) continue;
                result2.add(tool);
            }
            return result2;
        }
    }
}

