/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.awt.FontMetrics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPresentationManager
implements Disposable {
    private static final Key<AnimationStep> ANIMATION_STEP = Key.create((String)"ParameterHintAnimationStep");
    private static final int ANIMATION_STEP_MS = 25;
    private static final int ANIMATION_CHARS_PER_STEP = 3;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static ParameterHintsPresentationManager getInstance() {
        return (ParameterHintsPresentationManager)ServiceManager.getService(ParameterHintsPresentationManager.class);
    }

    private ParameterHintsPresentationManager() {
    }

    public List<Inlay> getParameterHintsInRange(@NotNull Editor editor, int startOffset, int endOffset) {
        return editor.getInlayModel().getInlineElementsInRange(startOffset, endOffset, MyRenderer.class);
    }

    public boolean isParameterHint(@NotNull Inlay inlay) {
        return inlay.getRenderer() instanceof MyRenderer;
    }

    public String getHintText(@NotNull Inlay inlay) {
        EditorCustomElementRenderer renderer2 = inlay.getRenderer();
        return renderer2 instanceof MyRenderer ? ((MyRenderer)renderer2).getText() : null;
    }

    public Inlay addHint(@NotNull Editor editor, int offset, boolean relatesToPrecedingText, @NotNull String hintText, @Nullable HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        MyRenderer renderer2 = new MyRenderer(editor, hintText, widthAdjuster, useAnimation);
        Inlay inlay = editor.getInlayModel().addInlineElement(offset, relatesToPrecedingText, (EditorCustomElementRenderer)renderer2);
        if (inlay != null && useAnimation) {
            this.scheduleRendererUpdate(editor, inlay);
        }
        return inlay;
    }

    public void deleteHint(@NotNull Editor editor, @NotNull Inlay hint, boolean useAnimation) {
        if (useAnimation) {
            this.updateRenderer(editor, hint, null, null, true);
        } else {
            Disposer.dispose((Disposable)hint);
        }
    }

    public void replaceHint(@NotNull Editor editor, @NotNull Inlay hint, @NotNull String newText, @Nullable HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        this.updateRenderer(editor, hint, newText, widthAdjuster, useAnimation);
    }

    public void setHighlighted(@NotNull Inlay hint, boolean highlighted) {
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer2 = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer2.highlighted;
        if (highlighted != oldValue) {
            renderer2.highlighted = highlighted;
            hint.repaint();
        }
    }

    public boolean isHighlighted(@NotNull Inlay hint) {
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer2 = (MyRenderer)hint.getRenderer();
        return renderer2.highlighted;
    }

    public void setCurrent(@NotNull Inlay hint, boolean current) {
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer2 = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer2.current;
        if (current != oldValue) {
            renderer2.current = current;
            hint.repaint();
        }
    }

    public boolean isCurrent(@NotNull Inlay hint) {
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer2 = (MyRenderer)hint.getRenderer();
        return renderer2.current;
    }

    private void updateRenderer(@NotNull Editor editor, @NotNull Inlay hint, @Nullable String newText, HintWidthAdjustment widthAdjuster, boolean useAnimation) {
        MyRenderer renderer2 = (MyRenderer)hint.getRenderer();
        renderer2.update(editor, newText, widthAdjuster, useAnimation);
        hint.updateSize();
        if (useAnimation) {
            this.scheduleRendererUpdate(editor, hint);
        }
    }

    public void dispose() {
    }

    private void scheduleRendererUpdate(@NotNull Editor editor, @NotNull Inlay inlay) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnimationStep step = (AnimationStep)editor.getUserData(ANIMATION_STEP);
        if (step == null) {
            step = new AnimationStep(editor);
            editor.putUserData(ANIMATION_STEP, (Object)step);
        }
        step.inlays.add(inlay);
        this.scheduleAnimationStep(step);
    }

    private void scheduleAnimationStep(@NotNull AnimationStep step) {
        this.myAlarm.cancelRequest((Runnable)step);
        this.myAlarm.addRequest((Runnable)step, 25, ModalityState.any());
    }

    public boolean isAnimationInProgress(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor.getUserData(ANIMATION_STEP) != null;
    }

    private class AnimationStep
    implements Runnable {
        private final Editor myEditor;
        private final Set<Inlay> inlays = new HashSet<Inlay>();

        AnimationStep(Editor editor) {
            this.myEditor = editor;
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), () -> ParameterHintsPresentationManager.this.myAlarm.cancelRequest((Runnable)this));
        }

        @Override
        public void run() {
            Iterator<Inlay> it = this.inlays.iterator();
            while (it.hasNext()) {
                Inlay inlay = it.next();
                if (inlay.isValid()) {
                    MyRenderer renderer2 = (MyRenderer)inlay.getRenderer();
                    if (!renderer2.nextStep()) {
                        it.remove();
                    }
                    if (renderer2.calcWidthInPixels(inlay) == 0) {
                        Disposer.dispose((Disposable)inlay);
                        continue;
                    }
                    inlay.updateSize();
                    continue;
                }
                it.remove();
            }
            if (this.inlays.isEmpty()) {
                this.myEditor.putUserData(ANIMATION_STEP, null);
            } else {
                ParameterHintsPresentationManager.this.scheduleAnimationStep(this);
            }
        }
    }

    private static class MyRenderer
    extends HintRenderer {
        private int startWidth;
        private int steps;
        private int step;
        private boolean highlighted;
        private boolean current;

        private MyRenderer(Editor editor, String text, HintWidthAdjustment widthAdjustment, boolean animated) {
            super(text);
            this.updateState(editor, text, widthAdjustment, animated);
        }

        public void update(Editor editor, String newText, HintWidthAdjustment widthAdjustment, boolean animated) {
            this.updateState(editor, newText, widthAdjustment, animated);
        }

        @Override
        @Nullable
        protected TextAttributes getTextAttributes(@NotNull Editor editor) {
            if (this.step > this.steps || this.startWidth != 0) {
                return editor.getColorsScheme().getAttributes(this.current ? DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_CURRENT : (this.highlighted ? DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED : DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT));
            }
            return null;
        }

        @Nullable
        public String getContextMenuGroupId(@NotNull Inlay inlay) {
            return "ParameterNameHints";
        }

        private void updateState(Editor editor, String text, HintWidthAdjustment widthAdjustment, boolean animated) {
            this.setWidthAdjustment(widthAdjustment);
            FontMetrics metrics = this.getFontMetrics(editor).getMetrics();
            this.startWidth = this.doCalcWidth(this.getText(), metrics);
            this.setText(text);
            int endWidth = this.doCalcWidth(this.getText(), metrics);
            this.steps = Math.max(1, Math.abs(endWidth - this.startWidth) / metrics.charWidth('a') / 3);
            this.step = animated ? 1 : this.steps + 1;
        }

        public boolean nextStep() {
            return ++this.step <= this.steps;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            int endWidth = super.calcWidthInPixels(inlay);
            return this.step <= this.steps ? Math.max(1, this.startWidth + (endWidth - this.startWidth) / this.steps * this.step) : endWidth;
        }
    }
}

