/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiChangeHandler
extends PsiTreeChangeAdapter
implements Disposable {
    private static final ExtensionPointName<ChangeLocalityDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.daemon.changeLocalityDetector");
    private final Key<Boolean> UPDATE_ON_COMMIT_ENGAGED = Key.create((String)"UPDATE_ON_COMMIT_ENGAGED");
    private final Project myProject;
    private final Map<Document, List<Pair<PsiElement, Boolean>>> changedElements = ContainerUtil.createWeakMap();
    private final FileStatusMap myFileStatusMap;

    PsiChangeHandler(@NotNull Project project, final @NotNull PsiDocumentManagerImpl documentManager, @NotNull EditorFactory editorFactory, @NotNull MessageBusConnection connection, @NotNull FileStatusMap fileStatusMap) {
        this.myProject = project;
        this.myFileStatusMap = fileStatusMap;
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                if (documentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                if (documentManager.getCachedPsiFile(document) == null) {
                    return;
                }
                if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) == null) {
                    document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, (Object)Boolean.TRUE);
                    PsiDocumentManagerBase.addRunOnCommit(document, () -> {
                        if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) != null) {
                            PsiChangeHandler.this.updateChangesForDocument(document);
                            document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
                        }
                    });
                }
            }
        }, (Disposable)this);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file2) {
                PsiChangeHandler.this.updateChangesForDocument(document);
                document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
            }
        });
    }

    public void dispose() {
    }

    private void updateChangesForDocument(@NotNull Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
        if (toUpdate == null) {
            if (UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document)) {
                return;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (file2 == null) {
                return;
            }
            toUpdate = Collections.singletonList(Pair.create((Object)file2, (Object)true));
        }
        Application application = ApplicationManager.getApplication();
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null && !application.isUnitTestMode()) {
            application.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    EditorMarkupModel markupModel = (EditorMarkupModel)editor.getMarkupModel();
                    PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                    ErrorStripeUpdateManager.getInstance(this.myProject).setOrRefreshErrorStripeRenderer(markupModel, file2);
                }
            }, ModalityState.stateForComponent((Component)editor.getComponent()), this.myProject.getDisposed());
        }
        for (Pair<PsiElement, Boolean> changedElement : toUpdate) {
            PsiElement element = (PsiElement)changedElement.getFirst();
            Boolean whiteSpaceOptimizationAllowed = (Boolean)changedElement.getSecond();
            this.updateByChange(element, document, whiteSpaceOptimizationAllowed);
        }
        this.changedElements.remove(document);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.queueElement(event.getParent(), true, event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        this.queueElement(event.getParent(), true, event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.queueElement(event.getNewChild(), PsiChangeHandler.typesEqual(event.getNewChild(), event.getOldChild()), event);
    }

    private static boolean typesEqual(PsiElement newChild, PsiElement oldChild) {
        return newChild != null && oldChild != null && newChild.getClass() == oldChild.getClass();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (((PsiTreeChangeEventImpl)event).isGenericChange()) {
            return;
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        this.queueElement(event.getOldParent(), true, event);
        this.queueElement(event.getNewParent(), true, event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            this.myFileStatusMap.markFileScopeDirtyDefensively(psiFile, event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (!propertyName.equals("writable")) {
            Object oldValue = event.getOldValue();
            if (oldValue instanceof VirtualFile && this.shouldBeIgnored((VirtualFile)oldValue)) {
                return;
            }
            this.myFileStatusMap.markAllFilesDirty(event);
        }
    }

    private void queueElement(@NotNull PsiElement child2, boolean whitespaceOptimizationAllowed, @NotNull PsiTreeChangeEvent event) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile file2 = event.getFile();
        if (file2 == null) {
            file2 = child2.getContainingFile();
        }
        if (file2 == null) {
            this.myFileStatusMap.markAllFilesDirty(child2);
            return;
        }
        if (!child2.isValid()) {
            return;
        }
        PsiDocumentManagerImpl pdm = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = pdm.getCachedDocument(file2);
        if (document != null) {
            if (pdm.getSynchronizer().getTransaction(document) == null) {
                this.myFileStatusMap.markAllFilesDirty(child2);
                return;
            }
            SmartList toUpdate = this.changedElements.get(document);
            if (toUpdate == null) {
                toUpdate = new SmartList();
                this.changedElements.put(document, (List<Pair<PsiElement, Boolean>>)toUpdate);
            }
            toUpdate.add(Pair.create((Object)child2, (Object)whitespaceOptimizationAllowed));
        }
    }

    private void updateByChange(@NotNull PsiElement child2, @NotNull Document document, boolean whitespaceOptimizationAllowed) {
        PsiElement element;
        PsiFile file2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            file2 = child2.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            this.myFileStatusMap.markAllFilesDirty((Object)e);
            return;
        }
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            this.myFileStatusMap.markAllFilesDirty(child2);
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && this.shouldBeIgnored(virtualFile)) {
            return;
        }
        int fileLength = file2.getTextLength();
        if (!file2.getViewProvider().isPhysical()) {
            this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, fileLength), fileLength, "Non-physical file update: " + file2);
            return;
        }
        PsiElement psiElement = element = whitespaceOptimizationAllowed && UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document) ? child2 : child2.getParent();
        while (true) {
            if (element == null || element instanceof PsiFile || element instanceof PsiDirectory) {
                this.myFileStatusMap.markAllFilesDirty("Top element: " + element);
                return;
            }
            PsiElement scope = PsiChangeHandler.getChangeHighlightingScope(element);
            if (scope != null) {
                this.myFileStatusMap.markFileScopeDirty(document, scope.getTextRange(), fileLength, "Scope: " + scope);
                return;
            }
            element = element.getParent();
        }
    }

    private boolean shouldBeIgnored(@NotNull VirtualFile virtualFile) {
        return ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) || ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isExcluded(virtualFile);
    }

    @Nullable
    private static PsiElement getChangeHighlightingScope(@NotNull PsiElement element) {
        DefaultChangeLocalityDetector defaultDetector = null;
        for (ChangeLocalityDetector detector : EP_NAME.getExtensionList()) {
            if (detector instanceof DefaultChangeLocalityDetector) {
                assert (defaultDetector == null) : defaultDetector;
                defaultDetector = (DefaultChangeLocalityDetector)detector;
                continue;
            }
            PsiElement scope = detector.getChangeHighlightingDirtyScopeFor(element);
            if (scope == null) continue;
            return scope;
        }
        assert (defaultDetector != null) : "com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector is unregistered";
        return defaultDetector.getChangeHighlightingDirtyScopeFor(element);
    }
}

