/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import gnu.trove.TIntFunction;
import gnu.trove.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements Comparator<HighlightSeverity> {
    static final int SHOWN_SEVERITIES_OFFSET = 1;
    private static final Logger LOG = Logger.getInstance(SeverityRegistrar.class);
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap = ContainerUtil.newConcurrentMap();
    private final Map<String, Color> myRendererColors = ContainerUtil.newConcurrentMap();
    static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = Topic.create((String)"SEVERITIES_CHANGED_TOPIC", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    private static final Topic<Runnable> STANDARD_SEVERITIES_CHANGED_TOPIC = Topic.create((String)"STANDARD_SEVERITIES_CHANGED_TOPIC", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_CHILDREN);
    @NotNull
    private final MessageBus myMessageBus;
    private volatile OrderMap myOrderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES = ContainerUtil.newConcurrentMap();
    private static final AtomicFieldUpdater<SeverityRegistrar, OrderMap> ORDER_MAP_UPDATER;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        this.myMessageBus = messageBus;
        messageBus.connect().subscribe(STANDARD_SEVERITIES_CHANGED_TOPIC, () -> {
            this.myOrderMap = null;
        });
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
        ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(STANDARD_SEVERITIES_CHANGED_TOPIC)).run();
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project) {
        return project == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProfileManager.getInstance(project).getCurrentProfile().getProfileManager().getSeverityRegistrar();
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info, Color renderColor) {
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.myOrderMap = null;
        HighlightDisplayLevel.registerSeverity((HighlightSeverity)severity, (TextAttributesKey)this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        ((Runnable)this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC)).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        HighlightInfoType infoType = STANDARD_SEVERITIES.get(severity.getName());
        if (infoType != null) {
            return (HighlightInfoType.HighlightInfoTypeImpl)infoType;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            return (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        return (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
        if (infoType != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(@NotNull Element element) {
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element);
        ArrayList<HighlightSeverity> read2 = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read2.add(severity);
        }
        this.myOrderMap = this.ensureAllStandardIncluded(read2, knownSeverities);
        this.severitiesChanged();
    }

    private OrderMap ensureAllStandardIncluded(List<? extends HighlightSeverity> read2, List<? extends HighlightSeverity> knownSeverities) {
        OrderMap orderMap = SeverityRegistrar.fromList(read2);
        if (orderMap.isEmpty()) {
            orderMap = SeverityRegistrar.fromList(knownSeverities);
        } else {
            List<HighlightSeverity> list2 = this.getSortedSeverities(orderMap);
            block0: for (HighlightSeverity highlightSeverity : knownSeverities) {
                if (list2.contains(highlightSeverity)) continue;
                for (int oIdx = 0; oIdx < list2.size(); ++oIdx) {
                    HighlightSeverity orderSeverity = list2.get(oIdx);
                    if (orderSeverity.myVal <= highlightSeverity.myVal) continue;
                    list2.add(oIdx, highlightSeverity);
                    this.myReadOrder = null;
                    continue block0;
                }
            }
            orderMap = SeverityRegistrar.fromList(list2);
        }
        return orderMap;
    }

    public void writeExternal(Element element) {
        List<HighlightSeverity> list2 = this.getAllSeverities();
        for (HighlightSeverity severity : list2) {
            Element info = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element);
        } else if (!this.getDefaultOrder().equals(list2)) {
            JDOMExternalizableStringList ext = new JDOMExternalizableStringList(Collections.nCopies(this.getOrderMap().size(), ""));
            this.getOrderMap().forEachEntry((orderSeverity, oIdx) -> {
                ext.set(oIdx, (Object)orderSeverity.getName());
                return true;
            });
            ext.writeExternal(element);
        }
    }

    @NotNull
    public List<HighlightSeverity> getAllSeverities() {
        return this.getSortedSeverities(this.getOrderMap());
    }

    @NotNull
    private List<HighlightSeverity> getSortedSeverities(OrderMap map2) {
        return Arrays.stream(map2.keys()).map(o -> (HighlightSeverity)o).sorted((o1, o2) -> this.compare((HighlightSeverity)o1, (HighlightSeverity)o2, map2)).collect(Collectors.toList());
    }

    int getSeveritiesCount() {
        return STANDARD_SEVERITIES.size() + this.myMap.size();
    }

    public HighlightSeverity getSeverityByIndex(int i) {
        HighlightSeverity[] found = new HighlightSeverity[1];
        this.getOrderMap().forEachEntry((severity, order) -> {
            if (order == i) {
                found[0] = severity;
                return false;
            }
            return true;
        });
        return found[0];
    }

    int getSeverityMaxIndex() {
        int[] values = this.getOrderMap().getValues();
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        HighlightInfoType type = STANDARD_SEVERITIES.get(name);
        if (type != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask((Color)this.myRendererColors.get(severity.getName()));
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        return STANDARD_SEVERITIES.containsKey(severityName) || this.myMap.containsKey(severityName);
    }

    @Override
    public int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2) {
        return this.compare(s1, s2, this.getOrderMap());
    }

    private int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2, @NotNull OrderMap orderMap) {
        int o1 = orderMap.getOrder(s1);
        int o2 = orderMap.getOrder(s2);
        return o1 - o2;
    }

    @NotNull
    private OrderMap getOrderMap() {
        OrderMap orderMap;
        OrderMap defaultOrder = null;
        while ((orderMap = this.myOrderMap) == null) {
            boolean replaced;
            if (defaultOrder == null) {
                defaultOrder = SeverityRegistrar.fromList(this.getDefaultOrder());
            }
            if (!(replaced = ORDER_MAP_UPDATER.compareAndSet((Object)this, null, (Object)defaultOrder))) continue;
            orderMap = defaultOrder;
            break;
        }
        return orderMap;
    }

    @NotNull
    private static OrderMap fromList(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList.size() != new HashSet<HighlightSeverity>(orderList).size()) {
            LOG.error("Severities order list MUST contain only unique severities: " + orderList);
        }
        TObjectIntHashMap map2 = new TObjectIntHashMap();
        for (int i = 0; i < orderList.size(); ++i) {
            HighlightSeverity severity = orderList.get(i);
            map2.put((Object)severity, i);
        }
        return new OrderMap(map2);
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        Collection<SeverityBasedTextAttributes> values = this.myMap.values();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + values.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : values) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        return order;
    }

    public void setOrder(@NotNull List<? extends HighlightSeverity> orderList) {
        this.myOrderMap = this.ensureAllStandardIncluded(orderList, this.getDefaultOrder());
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    int getSeverityIdx(@NotNull HighlightSeverity severity) {
        return this.getOrderMap().getOrder(severity);
    }

    public static boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            if (!provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    Collection<SeverityBasedTextAttributes> allRegisteredAttributes() {
        return Collections.unmodifiableCollection(this.myMap.values());
    }

    @NotNull
    Collection<HighlightInfoType> standardSeverities() {
        return STANDARD_SEVERITIES.values();
    }

    static {
        SeverityRegistrar.registerStandard(HighlightInfoType.ERROR, HighlightSeverity.ERROR);
        SeverityRegistrar.registerStandard(HighlightInfoType.WARNING, HighlightSeverity.WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.INFO, HighlightSeverity.INFO);
        SeverityRegistrar.registerStandard(HighlightInfoType.WEAK_WARNING, HighlightSeverity.WEAK_WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        STANDARD_SEVERITIES.put(HighlightDisplayLevel.DO_NOT_SHOW.getName(), HighlightInfoType.INFORMATION);
        ORDER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(SeverityRegistrar.class, OrderMap.class);
    }

    public static class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        SeverityBasedTextAttributes(@NotNull Element element) {
            this(new TextAttributes(element), new HighlightInfoType.HighlightInfoTypeImpl(element));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            return this.myAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            return this.myType;
        }

        private void writeExternal(@NotNull Element element) {
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myType.getSeverity(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (!this.myAttributes.equals((Object)that.myAttributes)) {
                return false;
            }
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            int result2 = this.myAttributes.hashCode();
            result2 = 31 * result2 + this.myType.hashCode();
            return result2;
        }
    }

    private static class OrderMap
    extends TObjectIntHashMap<HighlightSeverity> {
        private OrderMap(@NotNull TObjectIntHashMap<? extends HighlightSeverity> map2) {
            super(map2.size());
            map2.forEachEntry((key, value) -> {
                super.put(key, value);
                return true;
            });
            this.trimToSize();
        }

        private int getOrder(@NotNull HighlightSeverity severity) {
            int index = this.index(severity);
            return index < 0 ? -1 : this._values[index];
        }

        public void clear() {
            throw new IncorrectOperationException("readonly");
        }

        protected void removeAt(int index) {
            throw new IncorrectOperationException("readonly");
        }

        public void transformValues(TIntFunction function) {
            throw new IncorrectOperationException("readonly");
        }

        public boolean adjustValue(HighlightSeverity key, int amount) {
            throw new IncorrectOperationException("readonly");
        }

        public int put(HighlightSeverity key, int value) {
            throw new IncorrectOperationException("readonly");
        }

        public int remove(HighlightSeverity key) {
            throw new IncorrectOperationException("readonly");
        }
    }
}

