/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class SeverityUtil {
    @NotNull
    public static Collection<SeverityRegistrar.SeverityBasedTextAttributes> getRegisteredHighlightingInfoTypes(@NotNull SeverityRegistrar registrar) {
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> collection = new ArrayList<SeverityRegistrar.SeverityBasedTextAttributes>(registrar.allRegisteredAttributes());
        for (HighlightInfoType type : registrar.standardSeverities()) {
            if (HighlightInfoType.INFORMATION.equals(type) || HighlightInfoType.INFO.equals(type)) continue;
            collection.add(SeverityUtil.getSeverityBasedTextAttributes(registrar, type));
        }
        collection.sort(Comparator.comparing(SeverityRegistrar.SeverityBasedTextAttributes::getSeverity, registrar.reversed()));
        return collection;
    }

    private static SeverityRegistrar.SeverityBasedTextAttributes getSeverityBasedTextAttributes(@NotNull SeverityRegistrar registrar, @NotNull HighlightInfoType type) {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme2.getAttributes(type.getAttributesKey());
        if (textAttributes != null) {
            return new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes, (HighlightInfoType.HighlightInfoTypeImpl)type);
        }
        TextAttributes severity = registrar.getTextAttributesBySeverity(type.getSeverity(null));
        return new SeverityRegistrar.SeverityBasedTextAttributes(severity, (HighlightInfoType.HighlightInfoTypeImpl)type);
    }
}

