/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    ShowAutoImportPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        super(project, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range2 = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range2.getStartOffset();
        this.myEndOffset = range2.getEndOffset();
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
    }

    @Override
    public void doApplyInformationToEditor() {
        TransactionGuard.submitTransaction((Disposable)this.myProject, this::addImports);
    }

    private void addImports() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!application.isHeadlessEnvironment() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor);
        for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
            HighlightInfo info = visibleHighlights.get(i);
            if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
            return;
        }
        for (HighlightInfo visibleHighlight : visibleHighlights) {
            if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
            return;
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return;
        }
        Document document = this.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && info.getSeverity() == HighlightSeverity.ERROR && !info.getFixTextRange().containsOffset(caretOffset)) {
                infos.add(info);
            }
            return true;
        }));
        List importers = ReferenceImporter.EP_NAME.getExtensionList();
        for (HighlightInfo info2 : infos) {
            ReferenceImporter importer;
            Iterator iterator = importers.iterator();
            while (iterator.hasNext() && !(importer = (ReferenceImporter)iterator.next()).autoImportReferenceAt(this.myEditor, this.myFile, info2.getActualStartOffset())) {
            }
        }
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, @NotNull Project project, @NotNull Editor editor) {
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project, null, startOffset, endOffset, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        }));
        return highlights;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return false;
        }
        PsiElement element = this.myFile.findElementAt(info.startOffset);
        if (element == null || !element.isValid()) {
            return false;
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2 = info.quickFixActionRanges;
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list2) {
            IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action instanceof HintAction) || !action.isAvailable(this.myProject, this.myEditor, this.myFile)) continue;
            return ((HintAction)action).showHint(this.myEditor);
        }
        return false;
    }

    @NotNull
    public static String getMessage(boolean multiple, @NotNull String name) {
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        return hintText;
    }
}

