/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories = new TIntObjectHashMap();
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
    private int nextAvailableId = 13;
    private boolean checkedForCycles;
    private final Project myProject;

    public TextEditorHighlightingPassRegistrarImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, @Nullable int[] runAfterCompletionOf, @Nullable int[] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int n;
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        if (forcedPassId == -1) {
            int n2 = this.nextAvailableId;
            n = n2;
            this.nextAvailableId = n2 + 1;
        } else {
            n = forcedPassId;
        }
        int passId = n;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + PassConfig.access$100(registered);
        this.myRegisteredPassFactories.put(passId, (Object)info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull int[] passesToIgnore) {
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        }
        TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        TIntArrayList passesRefusedToCreate = new TIntArrayList();
        boolean isDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            if (ArrayUtil.find((int[])passesToIgnore, (int)passId) != -1) {
                return true;
            }
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            TextEditorHighlightingPass textEditorHighlightingPass = pass = isDumb && !DumbService.isDumbAware((Object)factory) ? null : factory.createHighlightingPass(psiFile, editor);
            if (pass == null || isDumb && !DumbService.isDumbAware((Object)pass)) {
                passesRefusedToCreate.add(passId);
            } else {
                pass.setColorsScheme(editor.getColorsScheme());
                TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                for (int id : passConfig.completionPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                for (int id : passConfig.startingPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                pass.setId(passId);
                id2Pass.put(passId, (Object)pass);
            }
            return true;
        });
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        passesRefusedToCreate.forEach(passId -> {
            statusMap.markFileUpToDate(document, passId);
            return true;
        });
        return Arrays.asList(id2Pass.getValues());
    }

    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        THashSet ids = new THashSet();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            if (factory instanceof MainHighlightingPassFactory && (pass = ((MainHighlightingPassFactory)factory).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) != null) {
                ids.add((Object)pass);
                pass.setId(passId);
            }
            return true;
        });
        return new ArrayList<TextEditorHighlightingPass>((Collection<TextEditorHighlightingPass>)ids);
    }

    private void checkForCycles() {
        TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((passId, config2) -> {
            TIntHashSet allPredecessors = new TIntHashSet(((PassConfig)config2).completionPredecessorIds);
            allPredecessors.addAll(((PassConfig)config2).startingPredecessorIds);
            transitivePredecessors.put(passId, (Object)allPredecessors);
            allPredecessors.forEach(predecessorId -> {
                PassConfig predecessor = (PassConfig)this.myRegisteredPassFactories.get(predecessorId);
                if (predecessor == null) {
                    return true;
                }
                TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                if (transitives == null) {
                    transitives = new TIntHashSet();
                    transitivePredecessors.put(predecessorId, (Object)transitives);
                }
                transitives.addAll(predecessor.completionPredecessorIds);
                transitives.addAll(predecessor.startingPredecessorIds);
                return true;
            });
            return true;
        });
        transitivePredecessors.forEachKey(passId -> {
            if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                throw new IllegalArgumentException("There is a cycle introduced involving pass " + ((PassConfig)this.myRegisteredPassFactories.get(passId)).passFactory);
            }
            return true;
        });
    }

    @Override
    @NotNull
    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        return this.myDirtyScopeTrackingFactories;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, @NotNull int[] completionPredecessorIds, @NotNull int[] startingPredecessorIds) {
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }
    }
}

