/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
implements TextEditorHighlightingPassFactory,
ProjectComponent {
    private final Set<PsiFile> mySkipWholeInspectionsCache = ContainerUtil.createWeakSet();
    private final ObjectIntMap<PsiFile> myPsiModificationCount = ContainerUtil.createWeakKeyIntValueMap();
    private final Project myProject;

    public WholeFileLocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
    }

    public void projectOpened() {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.myProject);
        profileManager.addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this::clearCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Set<PsiFile> set2 = this.mySkipWholeInspectionsCache;
        synchronized (set2) {
            this.mySkipWholeInspectionsCache.clear();
        }
        set2 = this.myPsiModificationCount;
        synchronized (set2) {
            this.myPsiModificationCount.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        long actualCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        Object object = this.myPsiModificationCount;
        synchronized (object) {
            if (this.myPsiModificationCount.get((Object)file2) == (int)actualCount) {
                return null;
            }
        }
        if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
            return null;
        }
        object = this.mySkipWholeInspectionsCache;
        synchronized (object) {
            if (this.mySkipWholeInspectionsCache.contains(file2)) {
                return null;
            }
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), (TextRange)visibleRange, true, new DefaultHighlightInfoProcessor(), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
                List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile2);
                List result2 = ContainerUtil.filter(tools, LocalInspectionToolWrapper::runForWholeFile);
                if (result2.isEmpty()) {
                    Set set2 = WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache;
                    synchronized (set2) {
                        WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache.add(file2);
                    }
                }
                return result2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                long modificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
                ObjectIntMap objectIntMap = WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount;
                synchronized (objectIntMap) {
                    WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount.put((Object)file2, (int)modificationCount);
                }
            }
        };
    }
}

