/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.WolfHighlightingPass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfPassFactory
implements TextEditorHighlightingPassFactory {
    private final Project myProject;
    private long myPsiModificationCount;

    public WolfPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, new int[]{7}, false, 9);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        final long psiModificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (psiModificationCount == this.myPsiModificationCount) {
            return null;
        }
        return new WolfHighlightingPass(this.myProject, editor.getDocument(), file2){

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WolfPassFactory.this.myPsiModificationCount = psiModificationCount;
            }
        };
    }
}

