/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class HtmlFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile vFile) {
        Module module;
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(vFile);
        Module module2 = module = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        if (module == null || !(file2 instanceof XmlFile)) {
            return Collections.emptyList();
        }
        String basePath = HtmlUtil.getHrefBase((XmlFile)file2);
        if (basePath != null && !HtmlUtil.hasHtmlPrefix(basePath)) {
            for (VirtualFile virtualFile : this.getBaseRoots(module)) {
                VirtualFile base = virtualFile.findFileByRelativePath(basePath);
                PsiDirectory result2 = base != null ? PsiManager.getInstance((Project)project).findDirectory(base) : null;
                if (result2 == null) continue;
                return Collections.singletonList(result2);
            }
        }
        return Collections.emptyList();
    }

    protected Collection<VirtualFile> getBaseRoots(Module module) {
        return Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file2)) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }
}

