/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RearrangeAttributesIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Rearrange tag attributes";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        XmlTag tag = RearrangeAttributesIntention.getTag(editor, file2);
        if (tag == null) {
            return false;
        }
        if (tag.getAttributes().length <= 1) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        return startEnd == null || offset <= startEnd.getTextRange().getEndOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        XmlTag tag = RearrangeAttributesIntention.getTag(editor, file2);
        if (tag == null) {
            return;
        }
        TextRange range2 = tag.getTextRange();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        ASTNode name = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
        TextRange reformatRange = new TextRange(name != null ? name.getTextRange().getEndOffset() + 1 : range2.getStartOffset() + 1, startEnd != null ? startEnd.getTextRange().getEndOffset() - 1 : range2.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(reformatRange);
        new RearrangeCodeProcessor(new ReformatCodeProcessor(project, file2, reformatRange, false)){

            @Override
            public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file2, boolean processChangedTextOnly) {
                return Collections.singleton(new TextRange(marker.getStartOffset(), marker.getEndOffset()));
            }
        }.run();
        editor.getCaretModel().moveToOffset(reformatRange.getStartOffset());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        element = file2.findElementAt(offset - 1);
        parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        return null;
    }
}

