/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
implements LocalQuickFix,
IntentionAction {
    private final String myLocalName;

    @Deprecated
    public RemoveAttributeIntentionFix(String localName, XmlAttribute attribute) {
        this(localName);
    }

    public RemoveAttributeIntentionFix(String localName) {
        this.myLocalName = localName;
    }

    public RemoveAttributeIntentionFix() {
        this(null);
    }

    @NotNull
    public String getName() {
        return XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.myLocalName != null ? this.getName() : this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return RemoveAttributeIntentionFix.getAttribute(editor, file2) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.removeAttribute((PsiElement)RemoveAttributeIntentionFix.getAttribute(editor, file2), editor);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement e = descriptor.getPsiElement();
        this.removeAttribute(e, null);
    }

    protected void removeAttribute(PsiElement e, Editor editor) {
        XmlAttribute myAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class, (boolean)false);
        if (myAttribute == null) {
            return;
        }
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute(myAttribute);
        myAttribute.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }

    private static XmlAttribute getAttribute(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), XmlAttribute.class);
        if (attribute == null) {
            attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset - 1), XmlAttribute.class);
        }
        return attribute;
    }
}

