/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlEnclosingTagUnwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveTagAndPromoteChildrenIntentionAction
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.tag.quickfix.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        XmlTag tag = RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, file2);
        if (tag == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (startEnd == null || offset <= startEnd.getStartOffset()) {
            return true;
        }
        ASTNode endStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
        return endStart == null || offset >= startEnd.getStartOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        new XmlEnclosingTagUnwrapper().unwrap(editor, (PsiElement)RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, file2));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(Editor editor, PsiFile file2) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        if (parent instanceof XmlAttribute) {
            return null;
        }
        element = file2.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }
}

