/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPathReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)value, holder);
            }

            public void visitXmlDoctype(XmlDoctype xmlDoctype) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)xmlDoctype, holder);
            }

            public void visitXmlTag(XmlTag tag) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)tag, holder);
            }
        };
    }

    private void checkRefs(PsiElement element, ProblemsHolder holder) {
        PsiReference[] references;
        for (PsiReference reference : references = element.getReferences()) {
            TextRange range2;
            boolean isHtml;
            if (!XmlHighlightVisitor.isUrlReference(reference) || XmlHighlightVisitor.isInjectedWithoutValidation(element) || !this.needToCheckRef(reference) || (isHtml = HtmlUtil.isHtmlTagContainingFile(element)) ^ this.isForHtml() || !isHtml && XmlHighlightVisitor.skipValidation(element)) continue;
            TextRange textRange = range2 = reference.getElement() == null ? null : reference.getElement().getTextRange();
            if (range2 == null || range2.isEmpty() || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    protected boolean needToCheckRef(PsiReference reference) {
        return true;
    }

    protected boolean isForHtml() {
        return false;
    }
}

