/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tooltips;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TooltipActionProvider {
    public static final ExtensionPointName<TooltipActionProvider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.daemon.tooltipActionProvider");
    public static final String SHOW_FIXES_KEY = "tooltips.show.actions.in.key";
    public static final boolean SHOW_FIXES_DEFAULT_VALUE = true;

    @Nullable
    public TooltipAction getTooltipAction(@NotNull HighlightInfo var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    public static TooltipAction calcTooltipAction(@NotNull HighlightInfo info, @NotNull Editor editor) {
        if (!Registry.is((String)"ide.tooltip.show.with.actions")) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        for (TooltipActionProvider extension : (TooltipActionProvider[])EXTENSION_POINT_NAME.getExtensions()) {
            TooltipAction action = extension.getTooltipAction(info, editor, file2);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static boolean isShowActions() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_FIXES_KEY, true);
    }

    public static void setShowActions(boolean newValue) {
        PropertiesComponent.getInstance().setValue(SHOW_FIXES_KEY, newValue, true);
    }
}

