/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalFilter {
    private static final Logger LOG = Logger.getInstance(AbstractExternalFilter.class);
    protected static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");
    protected static final Pattern ourHtmlFileSuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    protected static final String HTML = "<HTML>";
    protected static final String HTML_CLOSE = "</HTML>";
    private static final Pattern CLASS_DATA_START = Pattern.compile("START OF CLASS DATA", 2);
    private static final Pattern CLASS_DATA_END = Pattern.compile("SUMMARY ========", 2);
    private static final Pattern NON_CLASS_DATA_END = Pattern.compile("<A (NAME|ID)=", 2);
    private static final Pattern ANNIHILATOR = Pattern.compile("/[^/^.]*/[.][.]/");
    private static final Pattern CHARSET_META = Pattern.compile("<meta[^>]+\\s*charset=\"?([\\w\\-]*)\\s*\">", 2);
    private static final String FIELD_SUMMARY = "<!-- =========== FIELD SUMMARY =========== -->";
    private static final String CLASS_SUMMARY = "<div class=\"summary\">";
    private static final String GREATEST_END_SECTION = "<!-- ========= END OF CLASS DATA ========= -->";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String HR = "<HR>";
    private static final String P = "<P>";
    private static final String DL = "<DL>";
    private static final String H2 = "H2";
    private static final String H2_CLOSE = "</H2>";
    private static final String BR = "<BR>";
    private static final String DT = "<DT>";

    protected static String doAnnihilate(String path) {
        int len = path.length();
        while (len > (len = (path = ANNIHILATOR.matcher(path).replaceAll("/")).length())) {
        }
        return path;
    }

    public CharSequence correctRefs(String root, CharSequence read2) {
        CharSequence result2 = read2;
        for (RefConvertor converter : this.getRefConverters()) {
            result2 = converter.refFilter(root, result2);
        }
        return result2;
    }

    protected abstract RefConvertor[] getRefConverters();

    @Nullable
    public String getExternalDocInfo(String url) throws Exception {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isDispatchThread() || app.isWriteAccessAllowed()) {
            LOG.error("May block indefinitely: shouldn't be called from EDT or under write lock");
            return null;
        }
        if (url == null || !MyJavadocFetcher.ourFree) {
            return null;
        }
        MyJavadocFetcher fetcher = new MyJavadocFetcher(url, (_url, input, result2) -> this.doBuildFromStream(_url, input, result2));
        try {
            app.executeOnPooledThread((Runnable)fetcher).get();
        }
        catch (Exception e) {
            return null;
        }
        Exception exception = fetcher.myException;
        if (exception != null) {
            fetcher.myException = null;
            throw exception;
        }
        return this.correctDocText(url, fetcher.data);
    }

    @NotNull
    protected String correctDocText(@NotNull String url, @NotNull CharSequence data) {
        CharSequence docText = this.correctRefs(ourAnchorSuffix.matcher(url).replaceAll(""), data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtered JavaDoc: " + docText + "\n");
        }
        return PlatformDocumentationUtil.fixupText(docText);
    }

    @Nullable
    public String getExternalDocInfoForElement(String docURL, PsiElement element) throws Exception {
        return this.getExternalDocInfo(docURL);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data) throws IOException {
        this.doBuildFromStream(url, input, data, true, true);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data, boolean searchForEncoding, boolean matchStart) throws IOException {
        String read2;
        ParseSettings settings = this.getParseSettings(url);
        Pattern startSection = settings.startPattern;
        Pattern endSection = settings.endPattern;
        boolean useDt = settings.useDt;
        data.append(HTML);
        URL baseUrl = VfsUtilCore.convertToURL((String)url);
        if (baseUrl != null) {
            data.append("<base href=\"").append(baseUrl).append("\">");
        }
        data.append("<style type=\"text/css\">  ul.inheritance {\n      margin:0;\n      padding:0;\n  }\n  ul.inheritance li {\n       display:inline;\n       list-style-type:none;\n  }\n  ul.inheritance li ul.inheritance {\n    margin-left:15px;\n    padding-left:15px;\n    padding-top:1px;\n  }\n</style>");
        String contentEncoding = null;
        BufferedReader buf = new BufferedReader(input);
        do {
            String foundEncoding;
            if ((read2 = buf.readLine()) == null || !searchForEncoding || (foundEncoding = AbstractExternalFilter.parseContentEncoding(read2)) == null) continue;
            contentEncoding = foundEncoding;
        } while (read2 != null && matchStart && !startSection.matcher(StringUtil.toUpperCase((String)read2)).find());
        if (input instanceof MyReader && contentEncoding != null && !contentEncoding.equalsIgnoreCase("UTF-8") && !contentEncoding.equals(((MyReader)input).getEncoding())) {
            try {
                data.setLength(0);
                this.doBuildFromStream(url, new MyReader(((MyReader)input).myInputStream, contentEncoding), data, false, true);
            }
            catch (ProcessCanceledException foundEncoding) {
                // empty catch block
            }
            return;
        }
        if (read2 == null) {
            data.setLength(0);
            if (matchStart && !settings.forcePatternSearch && input instanceof MyReader) {
                try {
                    MyReader reader = contentEncoding != null ? new MyReader(((MyReader)input).myInputStream, contentEncoding) : new MyReader(((MyReader)input).myInputStream, ((MyReader)input).getEncoding());
                    this.doBuildFromStream(url, reader, data, false, false);
                }
                catch (ProcessCanceledException reader) {
                    // empty catch block
                }
            }
            return;
        }
        if (useDt) {
            boolean skip = false;
            do {
                if (StringUtil.containsIgnoreCase((String)read2, (String)H2_CLOSE) && !StringUtil.containsIgnoreCase((String)read2, (String)H2)) {
                    data.append(H2_CLOSE);
                    skip = true;
                    continue;
                }
                if (endSection.matcher(read2).find() || StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) != -1) {
                    data.append(HTML_CLOSE);
                    return;
                }
                if (skip) continue;
                AbstractExternalFilter.appendLine(data, read2);
            } while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).trim().equals(DL) && !StringUtil.containsIgnoreCase((String)read2, (String)"<div class=\"description\""));
            data.append(DL);
            StringBuilder classDetails = new StringBuilder();
            while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).equals(HR) && !StringUtil.toUpperCase((String)read2).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data, read2, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read2)) continue;
                AbstractExternalFilter.appendLine(classDetails, read2);
            }
            while ((read2 = buf.readLine()) != null && !StringUtil.toUpperCase((String)read2).equals(HR) && !StringUtil.toUpperCase((String)read2).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data, read2, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read2)) continue;
                AbstractExternalFilter.appendLine(data, StringUtil.replace((String)read2, (String)DT, (String)"<DT><BR>"));
            }
            data.append((CharSequence)classDetails);
            data.append(P);
        } else {
            AbstractExternalFilter.appendLine(data, read2);
        }
        while ((read2 = buf.readLine()) != null && !endSection.matcher(read2).find() && StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) == -1) {
            if (AbstractExternalFilter.skipBlockList(read2)) continue;
            AbstractExternalFilter.appendLine(data, read2);
        }
        data.append(HTML_CLOSE);
    }

    private static boolean skipBlockList(String read2) {
        return StringUtil.containsIgnoreCase((String)read2, (String)HR) || StringUtil.containsIgnoreCase((String)read2, (String)"<ul class=\"blockList\">") || StringUtil.containsIgnoreCase((String)read2, (String)"<li class=\"blockList\">");
    }

    @NotNull
    protected ParseSettings getParseSettings(@NotNull String url) {
        Pattern startSection = CLASS_DATA_START;
        Pattern endSection = CLASS_DATA_END;
        boolean anchorPresent = false;
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        if (anchorMatcher.find()) {
            anchorPresent = true;
            startSection = Pattern.compile("<a (name|id)=\"" + Pattern.quote(StringUtil.escapeXmlEntities((String)anchorMatcher.group(1))) + "\"", 2);
            endSection = NON_CLASS_DATA_END;
        }
        return new ParseSettings(startSection, endSection, !anchorPresent, anchorPresent);
    }

    private static boolean reachTheEnd(StringBuilder data, String read2, StringBuilder classDetails, Pattern endSection) {
        if (StringUtil.indexOfIgnoreCase((String)read2, (String)FIELD_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read2, (String)CLASS_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read2, (String)GREATEST_END_SECTION, (int)0) != -1 || endSection.matcher(read2).find()) {
            data.append((CharSequence)classDetails);
            data.append(HTML_CLOSE);
            return true;
        }
        return false;
    }

    @Nullable
    static String parseContentEncoding(@NotNull String htmlLine) {
        Matcher matcher;
        if (htmlLine.contains("charset") && (matcher = CHARSET_META.matcher(htmlLine)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static void appendLine(StringBuilder buffer, String read2) {
        buffer.append(read2);
        buffer.append("\n");
    }

    protected static class ParseSettings {
        @NotNull
        private final Pattern startPattern;
        @NotNull
        private final Pattern endPattern;
        private final boolean forcePatternSearch;
        private final boolean useDt;

        public ParseSettings(@NotNull Pattern startPattern, @NotNull Pattern endPattern, boolean useDt, boolean forcePatternSearch) {
            this.startPattern = startPattern;
            this.endPattern = endPattern;
            this.useDt = useDt;
            this.forcePatternSearch = forcePatternSearch;
        }
    }

    private static class MyReader
    extends InputStreamReader {
        private final ByteArrayInputStream myInputStream;

        MyReader(ByteArrayInputStream in) {
            super(in);
            in.reset();
            this.myInputStream = in;
        }

        MyReader(ByteArrayInputStream in, String charsetName) throws UnsupportedEncodingException {
            super((InputStream)in, charsetName);
            in.reset();
            this.myInputStream = in;
        }
    }

    private static class MyJavadocFetcher
    implements Runnable {
        private static boolean ourFree = true;
        private final StringBuilder data = new StringBuilder();
        private final String url;
        private final MyDocBuilder myBuilder;
        private Exception myException;

        MyJavadocFetcher(String url, MyDocBuilder builder2) {
            this.url = url;
            this.myBuilder = builder2;
            ourFree = false;
        }

        @Override
        public void run() {
            try {
                if (this.url == null) {
                    return;
                }
                if (this.url.startsWith(AbstractExternalFilter.JAR_PROTOCOL)) {
                    VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(BrowserUtil.getDocURL((String)this.url));
                    if (file2 != null) {
                        this.myBuilder.buildFromStream(this.url, new StringReader(VfsUtilCore.loadText((VirtualFile)file2)), this.data);
                    }
                } else {
                    URL parsedUrl = BrowserUtil.getURL((String)this.url);
                    if (parsedUrl != null) {
                        HttpRequests.request((String)parsedUrl.toString()).gzip(false).connect(request -> {
                            String contentEncoding = request.getConnection().getContentEncoding();
                            byte[] bytes = request.readBytes(null);
                            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                            if (contentEncoding == null) {
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                                    String htmlLine = reader.readLine();
                                    while (htmlLine != null) {
                                        contentEncoding = AbstractExternalFilter.parseContentEncoding(htmlLine);
                                        if (contentEncoding != null) {
                                            break;
                                        }
                                        htmlLine = reader.readLine();
                                    }
                                }
                            }
                            this.myBuilder.buildFromStream(this.url, contentEncoding != null ? new MyReader(stream, contentEncoding) : new MyReader(stream), this.data);
                            return null;
                        });
                    }
                }
            }
            catch (ProcessCanceledException parsedUrl) {
            }
            catch (IOException e) {
                this.myException = e;
            }
            finally {
                ourFree = true;
            }
        }
    }

    private static interface MyDocBuilder {
        public void buildFromStream(String var1, Reader var2, StringBuilder var3) throws IOException;
    }

    protected static abstract class RefConvertor {
        final Pattern mySelector;

        public RefConvertor(@NotNull Pattern selector) {
            this.mySelector = selector;
        }

        protected abstract String convertReference(String var1, String var2);

        public CharSequence refFilter(String root, @NotNull CharSequence read2) {
            StringBuilder ready = new StringBuilder();
            int prev2 = 0;
            Matcher matcher = this.mySelector.matcher(read2);
            while (matcher.find()) {
                CharSequence before = read2.subSequence(prev2, matcher.start(1) - 1);
                CharSequence href = read2.subSequence(matcher.start(1), matcher.end(1));
                prev2 = matcher.end(1) + 1;
                ready.append(before);
                ready.append("\"");
                ready.append((String)ReadAction.compute(() -> this.convertReference(root, href.toString())));
                ready.append("\"");
            }
            ready.append(read2, prev2, read2.length());
            return ready;
        }
    }
}

