/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickDocOnMouseOverManager {
    private static final Logger LOG = Logger.getInstance(QuickDocOnMouseOverManager.class);
    @NotNull
    private final MyEditorMouseListener myMouseListener = new MyEditorMouseListener();
    @NotNull
    private final VisibleAreaListener myVisibleAreaListener = new MyVisibleAreaListener();
    @NotNull
    private final CaretListener myCaretListener = new MyCaretListener();
    @NotNull
    private final DocumentListener myDocumentListener = new MyDocumentListener();
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final Map<Document, Boolean> myMonitoredDocuments = ContainerUtil.createWeakMap();
    private final Map<Editor, Reference<PsiElement>> myActiveElements = ContainerUtil.createWeakMap();
    @Nullable
    private WeakReference<DocumentationManager> myDocumentationManager;
    private boolean myEnabled;
    private boolean myApplicationActive;
    private MyShowQuickDocRequest myCurrentRequest;

    public QuickDocOnMouseOverManager(@NotNull Application application) {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)application);
        EditorFactory factory = EditorFactory.getInstance();
        if (factory != null) {
            factory.addEditorFactoryListener((EditorFactoryListener)new MyEditorFactoryListener(), (Disposable)application);
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                QuickDocOnMouseOverManager.this.myApplicationActive = true;
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                QuickDocOnMouseOverManager.this.myApplicationActive = false;
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        });
    }

    public void setEnabled(boolean enabled) {
        EditorFactory factory;
        this.myEnabled = enabled;
        this.myApplicationActive = enabled;
        if (!enabled) {
            this.closeQuickDocIfPossible();
            this.myAlarm.cancelAllRequests();
        }
        if ((factory = EditorFactory.getInstance()) == null) {
            return;
        }
        for (Editor editor : factory.getAllEditors()) {
            if (enabled) {
                this.registerListeners(editor);
                continue;
            }
            this.unRegisterListeners(editor);
        }
    }

    private void registerListeners(@NotNull Editor editor) {
        editor.addEditorMouseListener((EditorMouseListener)this.myMouseListener);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.myMouseListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().addCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.put(document, Boolean.TRUE) == null) {
            document.addDocumentListener(this.myDocumentListener);
        }
    }

    private void unRegisterListeners(@NotNull Editor editor) {
        editor.removeEditorMouseListener((EditorMouseListener)this.myMouseListener);
        editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.myMouseListener);
        editor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().removeCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.remove(document) != null) {
            document.removeDocumentListener(this.myDocumentListener);
        }
    }

    private void processMouseExited() {
        this.myActiveElements.clear();
        this.myAlarm.cancelAllRequests();
    }

    private void processMouseMove(@NotNull EditorMouseEvent e) {
        PsiFile psiFile;
        if (!this.myApplicationActive || !this.myEnabled || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            this.closeQuickDocIfPossible();
            return;
        }
        if (e.getMouseEvent().getModifiers() != 0) {
            return;
        }
        Editor editor = e.getEditor();
        if (EditorMouseHoverPopupControl.arePopupsDisabled(editor)) {
            return;
        }
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance(project);
        JBPopup hint = documentationManager.getDocInfoHint();
        if (hint != null) {
            DocumentationManager manager = this.getDocManager();
            if (manager == null || !manager.isCloseOnSneeze()) {
                return;
            }
            Point hintLocation = hint.getLocationOnScreen();
            Dimension hintSize = hint.getSize();
            int mouseX = e.getMouseEvent().getXOnScreen();
            int mouseY = e.getMouseEvent().getYOnScreen();
            int resizeZoneWidth = editor.getLineHeight();
            if (mouseX >= hintLocation.x - resizeZoneWidth && mouseX <= hintLocation.x + hintSize.width + resizeZoneWidth && mouseY >= hintLocation.y - resizeZoneWidth && mouseY <= hintLocation.y + hintSize.height + resizeZoneWidth) {
                return;
            }
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null) {
            this.closeQuickDocIfPossible();
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (editor instanceof EditorEx && ((EditorEx)editor).getFoldingModel().getFoldingPlaceholderAt(point) != null) {
            this.closeQuickDocIfPossible();
            return;
        }
        VisualPosition visualPosition = editor.xyToVisualPosition(point);
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
            this.closeQuickDocIfPossible();
            return;
        }
        int mouseOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(visualPosition));
        PsiElement elementUnderMouse = psiFile.findElementAt(mouseOffset);
        if (elementUnderMouse == null || elementUnderMouse instanceof PsiWhiteSpace || elementUnderMouse instanceof PsiPlainText) {
            this.closeQuickDocIfPossible();
            return;
        }
        if (elementUnderMouse.equals(SoftReference.dereference(this.myActiveElements.get(editor))) && (!this.myAlarm.isEmpty() || hint != null)) {
            return;
        }
        this.allowUpdateFromContext(project, false);
        this.closeQuickDocIfPossible();
        this.myActiveElements.put(editor, new WeakReference<PsiElement>(elementUnderMouse));
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentRequest != null) {
            this.myCurrentRequest.cancel();
        }
        this.myCurrentRequest = new MyShowQuickDocRequest(documentationManager, editor, mouseOffset, elementUnderMouse);
        this.myAlarm.addRequest((Runnable)this.myCurrentRequest, EditorSettingsExternalizable.getInstance().getQuickDocOnMouseOverElementDelayMillis());
    }

    private void closeQuickDocIfPossible() {
        JBPopup hint;
        this.myAlarm.cancelAllRequests();
        DocumentationManager docManager = this.getDocManager();
        if (docManager != null && (hint = docManager.getDocInfoHint()) != null) {
            hint.cancel();
        }
    }

    private void allowUpdateFromContext(Project project, boolean allow) {
        DocumentationManager documentationManager = this.getDocManager();
        if (documentationManager != null && documentationManager.getProject(null) == project) {
            documentationManager.setAllowContentUpdateFromContext(allow);
        }
    }

    @Nullable
    private DocumentationManager getDocManager() {
        return (DocumentationManager)SoftReference.dereference(this.myDocumentationManager);
    }

    @Nullable
    private Editor getEditor() {
        DocumentationManager manager = this.getDocManager();
        return manager == null ? null : manager.getEditor();
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor.getDocument() == e.getDocument()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.allowUpdateFromContext(e.getEditor().getProject(), true);
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        private MyEditorMouseListener() {
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            QuickDocOnMouseOverManager.this.processMouseExited();
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            QuickDocOnMouseOverManager.this.processMouseMove(e);
        }
    }

    private class MyEditorFactoryListener
    implements EditorFactoryListener {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.registerListeners(event.getEditor());
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.unRegisterListeners(event.getEditor());
            }
        }
    }

    private class MyCloseDocCallback
    implements Runnable {
        @NotNull
        private final Editor myEditor;

        private MyCloseDocCallback(Editor editor) {
            this.myEditor = editor;
        }

        @Override
        public void run() {
            QuickDocOnMouseOverManager.this.myActiveElements.clear();
            this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
            QuickDocOnMouseOverManager.this.myDocumentationManager = null;
        }
    }

    private class MyShowQuickDocRequest
    implements Runnable {
        @NotNull
        private final DocumentationManager docManager;
        @NotNull
        private final Editor editor;
        private final int offset;
        @NotNull
        private final PsiElement originalElement;
        @NotNull
        private final ProgressIndicator myProgressIndicator = new ProgressIndicatorBase();

        private MyShowQuickDocRequest(@NotNull DocumentationManager docManager, Editor editor, @NotNull int offset, PsiElement originalElement) {
            this.docManager = docManager;
            this.editor = editor;
            this.offset = offset;
            this.originalElement = originalElement;
        }

        private void cancel() {
            this.myProgressIndicator.cancel();
        }

        @Override
        public void run() {
            Ref targetElementRef = new Ref();
            QuickDocUtil.runInReadActionWithWriteActionPriorityWithRetries(() -> {
                if (this.originalElement.isValid()) {
                    targetElementRef.set((Object)this.docManager.findTargetElement(this.editor, this.offset, this.originalElement.getContainingFile(), this.originalElement));
                }
            }, 5000L, 100L, this.myProgressIndicator);
            Ref documentationRef = new Ref();
            if (!targetElementRef.isNull()) {
                try {
                    documentationRef.set((Object)this.docManager.generateDocumentation((PsiElement)targetElementRef.get(), this.originalElement));
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                QuickDocOnMouseOverManager.this.myCurrentRequest = null;
                if (this.editor.isDisposed() || IdeTooltipManager.getInstance().hasCurrent() && !this.docManager.hasActiveDockedDocWindow()) {
                    return;
                }
                PsiElement targetElement = (PsiElement)targetElementRef.get();
                String documentation = (String)documentationRef.get();
                if (targetElement == null || StringUtil.isEmpty((String)documentation)) {
                    QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
                    return;
                }
                QuickDocOnMouseOverManager.this.myAlarm.cancelAllRequests();
                if (!this.originalElement.equals(SoftReference.dereference((Reference)((Reference)QuickDocOnMouseOverManager.this.myActiveElements.get(this.editor))))) {
                    return;
                }
                if (this.docManager.getDocInfoHint() != null && !this.docManager.isCloseOnSneeze()) {
                    return;
                }
                this.editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)this.editor.offsetToVisualPosition(this.originalElement.getTextRange().getStartOffset()));
                this.docManager.showJavaDocInfo(this.editor, targetElement, this.originalElement, new MyCloseDocCallback(this.editor), documentation, true);
                QuickDocOnMouseOverManager.this.myDocumentationManager = new WeakReference<DocumentationManager>(this.docManager);
            }, ApplicationManager.getApplication().getNoneModalityState());
        }
    }
}

