/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler {
    private static final Logger LOGGER = Logger.getInstance(BackspaceHandler.class);
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        if (!this.handleBackspace(editor, caret, dataContext, false)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    protected boolean handleBackspace(Editor editor, Caret caret, DataContext dataContext, boolean toWordStart) {
        HighlighterIterator iterator;
        int injectedOffset;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file2 == null) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = DocumentUtil.getPreviousCodePointOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int c = Character.codePointAt(chars, offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor, file2);
        Editor originalEditor = editor;
        if (injectedEditor != editor && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
            offset = DocumentUtil.getPreviousCodePointOffset(injectedEditor.getDocument(), injectedOffset);
        }
        List delegates = BackspaceHandlerDelegate.EP_NAME.getExtensionList();
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                delegate.beforeCharDeleted((char)c, file2, editor);
            }
        }
        FileType fileType = file2.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        HighlighterIterator hiterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(originalEditor, caret, dataContext);
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                if (!delegate.charDeleted((char)c, file2, editor)) continue;
                return true;
            }
        }
        if (offset >= editor.getDocument().getTextLength()) {
            return true;
        }
        chars = editor.getDocument().getCharsSequence();
        if ((c == 40 || c == 91 || c == 123) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c1 != BackspaceHandler.getRightChar((char)c)) {
                return true;
            }
            iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, fileType) && !braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator, iterator.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(rparenOffset), false, true))) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        } else if ((c == 34 || c == 39 || c == 96) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator, offset)) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    public static char getRightChar(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        assert (false);
        return c;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file2, Editor editor) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor)) {
            return null;
        }
        int indent = CodeStyle.getIndentOptions((PsiFile)file2).INDENT_SIZE;
        int column = indent > 0 ? (caretPos.column - 1) / indent * indent : 0;
        return new LogicalPosition(caretPos.line, column);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor, @NotNull LogicalPosition pos) {
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        if (logicalPosition.line != pos.line) {
            LOGGER.error("Unexpected caret position: " + logicalPosition + ", target indent position: " + pos);
            return;
        }
        if (pos.column < logicalPosition.column) {
            int targetOffset = editor.logicalPositionToOffset(pos);
            int offset = editor.getCaretModel().getOffset();
            editor.getSelectionModel().setSelection(targetOffset, offset);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            editor.getCaretModel().moveToLogicalPosition(pos);
        } else if (pos.column > logicalPosition.column) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)' ', (int)(pos.column - logicalPosition.column)));
        }
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor) {
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset = editor.logicalPositionToOffset(checkPos);
            if (offset >= charSeq.length() || (c = charSeq.charAt(offset)) == '\t' || c == ' ' || c == '\n') continue;
            return false;
        }
        return true;
    }
}

